-----------------------------------
-- func: incursion
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 5,
    parameters = "s"
}

local incursionAreas =
{
    ["1"] =
    {
        name = "Fort Ghelsba",
        item = xi.item.BEASTMAN_BANNER,
        pos  = { -142.947, -20.275, 32.396, 45, xi.zone.FORT_GHELSBA },
    },

    ["2"] =
    {
        name = "Palborough Mines",
        item = xi.item.BEASTMAN_BANNER,
        pos  = { 201.968, 0.193, 100.398, 246, xi.zone.PALBOROUGH_MINES },
    },

    ["3"] =
    {
        name = "Giddeus",
        item = xi.item.BEASTMAN_BANNER,
        pos  = { -55.653, 4.108, 303.747, 208, xi.zone.GIDDEUS },
    },

    ["4"] =
    {
        name = "Davoi",
        item = xi.item.BEASTMAN_BANNER,
        pos  = { 166.800, 0.776, -136.945, 0, xi.zone.DAVOI },
    },

    ["5"] =
    {
        name = "Beadeaux",
        item = xi.item.BEASTMAN_BANNER,
        pos  = { -99.848, 0.500, 56.788, 0, xi.zone.BEADEAUX },
    },

    ["6"] =
    {
        name = "Castle_Oztroja",
        item = xi.item.BEASTMAN_BANNER,
        pos  = { -136.043, 0.248, -105.970, 0, xi.zone.CASTLE_OZTROJA },
    },
}

commandObj.onTrigger = function(player, command)
    if command == "clear" then
        local zoneID = player:getZoneID()
        player:setCharVar("[INC]STEP",                  0)
        player:setCharVar("[INC]ZONE",                  0)
        player:setCharVar("[INC]PHASE",                 0)
        player:setCharVar("[INC]MOBS",                  0)
        player:setCharVar("[INC]BUFFS",                 0)
        player:setCharVar(fmt("[INC]DELAY_{}", zoneID), 0)
        SetServerVariable(fmt("[INC]RESERVED_{}", zoneID), 0)
        player:sys("Cleared all Incursion related variables.")

        return
    end

    local selectedArea = incursionAreas[command]

    if selectedArea ~= nil then
        player:addItem(selectedArea.item)
        player:setPos(unpack(selectedArea.pos))
    end
end

return commandObj
