-----------------------------------
-- func: !checktrial
-- desc: Checks and prints the trial information of a specified player.
-----------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = "s"
}

local function bitRShift(x, n)
    return math.floor(x / 2^n)
end


local function bitAnd(a, b)
    local result = 0
    local bitVal = 1
    while a > 0 and b > 0 do
        if a % 2 == 1 and b % 2 == 1 then
            result = result + bitVal
        end
        bitVal = bitVal * 2
        a = math.floor(a / 2)
        b = math.floor(b / 2)
    end
    return result
end

local function showError(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!checktrial <player>")
end

commandObj.onTrigger = function(player, targetName)
    local target = nil

    if targetName and targetName ~= "" then
        target = GetPlayerByName(targetName)
    elseif player:getCursorTarget() and player:getCursorTarget():isPC() then
        target = player:getCursorTarget()
    end

    if not target then
        showError(player, "Invalid target.")
        return
    end

    local hasActiveTrials = false

    -- Check and decode each trial
    for i = 1, 10 do
        local trialVar = string.format("[trial]%d", i)
        local packedTrial = target:getCharVar(trialVar)

        if packedTrial and packedTrial > 0 then
            local trialId = bitRShift(packedTrial, 16)
            local trialProgress = bitAnd(packedTrial, 0xFFFF)

            -- Print the decoded trial info
            player:printToPlayer(string.format("Trial %d: ID = %d, Progress = %d", i, trialId, trialProgress))
            hasActiveTrials = true
        end
    end

    if not hasActiveTrials then
        player:printToPlayer(string.format("%s does not have any active trials.", target:getName()))
    end
end

return commandObj
