-----------------------------------
-- !cwreset <player>
-- Reset Crystal Warrior
-----------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = "s"
}

local function error(player, msg)
    player:printToPlayer(msg)
    player:printToPlayer("!cwreset (name)")
end

commandObj.onTrigger = function(player, playerName)
    if playerName == nil then
        error(player, string.format("Player name missing"))
        return
    end

    if IsCrystalWarriorAccount(playerName) then
        local targ = GetPlayerByName(playerName)

        if targ then
            targ:printToPlayer("Your Crystal Warrior is being reset. Please log out immediately.", xi.msg.channel.SYSTEM_3)
        end

        local result = RestartCrystalWarrior(playerName)

        if result then
            player:printToPlayer(string.format("%s's Crystal Warrior was reset to Provenance.", playerName))
        else
            player:printToPlayer(string.format("%s's Crystal Warrior was not reset. Something went wrong.", playerName))
        end
    else
        error(player, string.format("Specified player is not a Crystal Warrior account."))
    end
end

return commandObj
