-----------------------------------
-- func: !cwintro
-- desc: Tests the Crystal Warrior intro sequence for the player's current nation
-----------------------------------

local commandObj = {}

commandObj.cmdprops =
{
    permission = 1,
    parameters = "i"
}

local areas =
{
    [xi.nation.SANDORIA] = { 152.145, 0.000, 195.839, 100,  xi.zone.KING_RANPERRES_TOMB }, -- !pos 152.145 0.000 195.839
    [xi.nation.BASTOK]   = { -452.215, 3.987, 133.918, 150, xi.zone.DANGRUF_WADI        }, -- !pos -452.215 3.987 133.918
    [xi.nation.WINDURST] = { 180.019, 8.500, 22.654, 64,    xi.zone.TORAIMARAI_CANAL    }, -- !pos 180.019 8.500 22.654
}

commandObj.onTrigger = function(player, nation)
    local currentNation = player:getNation()

    if nation ~= nil then
        currentNation = nation
    end

    player:setCharVar("[CW]INTRO", 1)
    player:setCrystalWarrior(true)

    local area = areas[currentNation]
    player:setHomePointAt(area[1], area[2], area[3], area[4], area[5])
    player:setPos(area[1], area[2], area[3], area[4], area[5])
end

return commandObj
