-----------------------------------
-- Wings-Era Warrior Missions
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("addon_wings_era_warrior")

local info =
{
    name   = "Wings-Era Warrior",
    author = "Loxley/Spicy",
    var    = "[CQ]WINGS_ERA_WARRIOR",
}

local REGAL_PAWPRINT  = "REGAL_PAWPRINT"
local REGAL_UPPER     = "REGAL_UPPER"
local RegalPawprint   = "Regal Pawprint"
local CAIT_SITH       = "CAIT_SITH"
local CAIT_SITH_UPPER = "CAIT_SITH_UPPER"
local CaitSith        = "Regal Feline"


local RIPPED_BARK    = "RIPPED_BARK"
local RippedBark     = "Ripped Bark"
local ORCISH_BRUTE   = "ORCISH_BRUTE"
local LILISETTE_CS   = "LILISETTE_CS"
local Lilisette      = "Lilisette"

local MAGIC_LILY_PAD = "MAGIC_LILY_PAD"
local MagicLilyPad   = "Magic Lily Pad"
local POROGGO_HERMIT = "POROGGO_HERMIT"

local LIBRARIAN      = "LIBRARIAN"

local GWEN           = "GWEN"
local Gwendolen      = "Gwendolen"

local SEALED_BOOK    = "SEALED_BOOK"
local SealedBook     = "Sealed Book"

local MYSTERIOUS_VOICE = "MYSTERIOUS_VOICE"
local MysteriousVoice  = "Mysterious Voice"

local MISSING_PAGE_1 = "MISSING_PAGE_1"
local MISSING_PAGE_2 = "MISSING_PAGE_2"
local MISSING_PAGE_3 = "MISSING_PAGE_3"

local SPECTRAL_RIFT   = "SPECTRAL_RIFT"
local CHAOS_AEONDRAKE = "CHAOS_AEONDRAKE"

local OMINOUS_SHADOW = "OMINOUS_SHADOW"
local VAMPYR         = "VAMPYR"

local collectPage =
{
    { animation = 48, target = "player", duration = 3000 }, -- Crouch down
    { emotion   = "collects a missing page." },
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local mobs =
{
    [ORCISH_BRUTE] =
    {
        id          = ORCISH_BRUTE,
        name        = "Orcish Brute",
        type        = xi.objType.MOB,
        groupId     = 40,
        groupZoneId = 81,
        area        = "East_Ronfaure_[S]",
        pos         = { 390.673, -38.467, 16.327, 184 }, -- !pos 390.673 -38.467 16.327 81
        level       = 42,
    },

    [POROGGO_HERMIT] =
    {
        id          = POROGGO_HERMIT,
        name        = "Poroggo Hermit",
        type        = xi.objType.MOB,
        groupId     = 22,
        groupZoneId = 132,
        area        = "Pashhow_Marshlands_[S]",
        pos         = { 142.759, 25.078, -407.896, 85 }, -- !pos 146.187 24.637 -414.117 90
        level       = 61,

        effects     =
        {
            [xi.effect.REGAIN]   = { 10, 0, 0 },
        },

        aeffect     = xi.mob.ae.ENWATER,
    },

    [CHAOS_AEONDRAKE] =
    {
        id          = CHAOS_AEONDRAKE,
        name        = "Chaos Aeondrake",
        type        = xi.objType.MOB,
        groupId     = 29,
        groupZoneId = 137,
        area        = "Meriphataud_Mountains_[S]",
        pos         = { 819.660, -12.611, 641.908, 118 }, -- !pos 819.660 -12.611 641.908 97
        level       = 90,

        onMobSpawn  = function(mob)
            mob:setUntargetable(false)
        end,

        mods        =
        {
            [xi.mod.WIND_ABSORB]          = 1000,
            [xi.mod.FIRE_RES_RANK]        = 1,
            [xi.mod.ICE_RES_RANK]         = -3,
            [xi.mod.WIND_RES_RANK]        = -3,
            [xi.mod.EARTH_RES_RANK]       = 11,
            [xi.mod.THUNDER_RES_RANK]     = 3,
            [xi.mod.WATER_RES_RANK]       = 6,
            [xi.mod.LIGHT_RES_RANK]       = -1,
            [xi.mod.DARK_RES_RANK]        = 11,
            [xi.mod.DARK_MEVA]            = 50,
            [xi.mod.GRAVITYRES]           = 10000,
            [xi.mod.SLEEPRES]             = 10000,
            [xi.mod.LULLABYRES]           = 10000,
            [xi.mod.STUN_MEVA]            = 500,
            [xi.mod.DOUBLE_ATTACK]        = 10,
            [xi.mod.STR]                  = 10,
            [xi.mod.MOVE_SPEED_STACKABLE] = 50,
            [xi.mod.HPP]                  = 100,
        },

        effects     =
        {
            [xi.effect.REGAIN]    = {  1, 3, 0 },
            [xi.effect.REGEN]     = { 15, 3, 0 },
            [xi.effect.STR_BOOST] = { 20, 0, 0 },
            [xi.effect.DEX_BOOST] = { 20, 0, 0 },
            [xi.effect.VIT_BOOST] = { 20, 0, 0 },
            [xi.effect.AGI_BOOST] = { 10, 0, 0 },
            [xi.effect.INT_BOOST] = { 10, 0, 0 },
        },

        aeffect     = xi.mob.ae.ENAERO,
    },

    [VAMPYR] =
    {
        id          = VAMPYR,
        name        = "Lord Heliron",
        type        = xi.objType.MOB,
        groupId     = 17,
        groupZoneId = 78,
        area        = "Escha_RuAun",
        pos         = { 134.013, -32.326, -205.611, 167 }, -- !pos 134.013 -32.326 -205.611 289
        level       = 95,

        mods        =
        {
            [xi.mod.DARK_ABSORB]      = 1000,
            [xi.mod.WIND_ABSORB]      = 1000,
            [xi.mod.FIRE_RES_RANK]    = -2,
            [xi.mod.ICE_RES_RANK]     = 4,
            [xi.mod.WIND_RES_RANK]    = 3,
            [xi.mod.EARTH_RES_RANK]   = 3,
            [xi.mod.THUNDER_RES_RANK] = 1,
            [xi.mod.WATER_RES_RANK]   = 1,
            [xi.mod.LIGHT_RES_RANK]   = -3,
            [xi.mod.DARK_RES_RANK]    = 11,
            [xi.mod.CRIT_DEF_BONUS]   = 10,
            [xi.mod.PIERCE_SDT]       = 200,
            [xi.mod.HPP]              = 1900,
            [xi.mod.DOUBLE_ATTACK]    = 15,
            [xi.mod.ATT]              = 30,
            [xi.mod.ACC]              = 10,
            [xi.mod.MATT]             = 15,
            [xi.mod.MACC]             = 10,
            [xi.mod.STORETP]          = 5,
            [xi.mod.FASTCAST]         = 15,
            [xi.mod.STR]              = 10,
            [xi.mod.VIT]              = 10,
        },

        effects     =
        {
            [xi.effect.REGAIN]     = {  1, 3, 0 },
            [xi.effect.REGEN]      = { 10, 3, 0 },
        },

        aeffect     = xi.mob.ae.ENDARK,

        onMobFight  = function(mob, target)
            cexi.mob_util.ignorePet(mob, target)
        end,
    },
}

local function pawprintDefault(player)
    local stepNum = player:getCharVar(info.var)
    if
        not player:isClassicMode() or
        stepNum == 0
    then
        player:fmt('You see nothing out of the ordinary')

        return
    end

    local stepMeta = cexi.questMeta.awr.step[stepNum]
    if stepNum >= #cexi.questMeta.awr.step then
        player:fmt('??? : Congratulations on completing AWR!')

        return
    elseif stepMeta then
        for idx, _ in pairs(stepMeta) do
            for _, tempEntity in pairs(cexi.questMeta.awr.entity) do
                -- find the entity metadata for their current mission
                if tempEntity.id == idx then
                    local prettyZoneName = string.gsub(tempEntity.area, '_', ' ')
                    player:fmt('??? : You\'re currently on the AWR step involving {} in {}', tempEntity.name, prettyZoneName)

                    return
                end
            end
        end
    end
end

local function librarianDefault(player)
    local menuOptions =
    {
        title = "Welcome to the Library:",
        options =
        {
            {
                "Auction House",
                function()
                    player:sendMenu(3)
                end,
            },
            {
                "Crafting Shop",
                function()
                    local craftStock =
                    {
                        -- HQ crystals
                        4238, 2000, -- inferno_crystal
                        4239, 2000, -- glacier_crystal
                        4240, 2000, -- cyclone_crystal
                        4241, 2000, -- terra_crystal
                        4242, 2000, -- plasma_crystal
                        4243, 2000, -- torrent_crystal
                        4244, 2000, -- aurora_crystal
                        4245, 2000, -- twilight_crystal
                        -- desynth from each craft
                        12292,  1500, -- mahogany_shield (sells for 830)
                        501,    100,  -- quadav_helm (sells for 5)
                        12307,  3500, -- heater_shield (sells for 3168)
                        1639,   1000, -- corse_robe (not sellable)
                        2519,   1000, -- yagudo_osode (not sellable)
                        13461,  2000, -- carapace_ring (sells for 1902)
                        17041,  3500, -- holy mace (sells for 3102)
                    }

                    xi.shop.general(player, craftStock)
                end,
            },
        },
    }

    local skills =
    {
        xi.skill.WOODWORKING,
        xi.skill.SMITHING,
        xi.skill.GOLDSMITHING,
        xi.skill.CLOTHCRAFT,
        xi.skill.LEATHERCRAFT,
        xi.skill.BONECRAFT,
        xi.skill.ALCHEMY,
        xi.skill.COOKING,
    }

    local function showVendor(player, npc, info)
        local skillID = info[2]
        -- copied from crafting_image_support.lua (using require would overwrite modules)
        local npcTable =
        {
            --    ['npc_name'] = { type, event, guild_id,           skill_id,              effect_id,                     },
            ['Panja-Nanja'   ] = { 0, 10011, xi.guild.FISHING,      xi.skill.FISHING,      xi.effect.FISHING_IMAGERY      }, -- Advanced
            ['Erabu-Fumulubu'] = { 1, 10012, xi.guild.FISHING,      xi.skill.FISHING,      xi.effect.FISHING_IMAGERY      }, -- Free
            ['Degong'        ] = { 2, 10013, xi.guild.FISHING,      xi.skill.FISHING,      xi.effect.FISHING_IMAGERY      }, -- Free
            ['Ulycille'      ] = { 0,   623, xi.guild.WOODWORKING,  xi.skill.WOODWORKING,  xi.effect.WOODWORKING_IMAGERY  }, -- Advanced
            ['Amarefice'     ] = { 1,   624, xi.guild.WOODWORKING,  xi.skill.WOODWORKING,  xi.effect.WOODWORKING_IMAGERY  }, -- Free
            ['Ramua'         ] = { 2,   625, xi.guild.WOODWORKING,  xi.skill.WOODWORKING,  xi.effect.WOODWORKING_IMAGERY  }, -- Free
            ['Wise_Owl'      ] = { 0,   103, xi.guild.SMITHING,     xi.skill.SMITHING,     xi.effect.SMITHING_IMAGERY     }, -- Advanced
            ['Hugues'        ] = { 1,   104, xi.guild.SMITHING,     xi.skill.SMITHING,     xi.effect.SMITHING_IMAGERY     }, -- Free
            ['Romero'        ] = { 2,   105, xi.guild.SMITHING,     xi.skill.SMITHING,     xi.effect.SMITHING_IMAGERY     }, -- Free
            ['Greubaque'     ] = { 0,   628, xi.guild.SMITHING,     xi.skill.SMITHING,     xi.effect.SMITHING_IMAGERY     }, -- Advanced
            ['Pinok-Morok'   ] = { 1,   629, xi.guild.SMITHING,     xi.skill.SMITHING,     xi.effect.SMITHING_IMAGERY     }, -- Free
            ['Beadurinc'     ] = { 2,   630, xi.guild.SMITHING,     xi.skill.SMITHING,     xi.effect.SMITHING_IMAGERY     }, -- Free
            ['Fatimah'       ] = { 0,   302, xi.guild.GOLDSMITHING, xi.skill.GOLDSMITHING, xi.effect.GOLDSMITHING_IMAGERY }, -- Advanced
            ['Wulfnoth'      ] = { 1,   303, xi.guild.GOLDSMITHING, xi.skill.GOLDSMITHING, xi.effect.GOLDSMITHING_IMAGERY }, -- Free
            ['Ulrike'        ] = { 2,   304, xi.guild.GOLDSMITHING, xi.skill.GOLDSMITHING, xi.effect.GOLDSMITHING_IMAGERY }, -- Free
            ['Terude-Harude' ] = { 0, 10013, xi.guild.CLOTHCRAFT,   xi.skill.CLOTHCRAFT,   xi.effect.CLOTHCRAFT_IMAGERY   }, -- Advanced
            ['Nikkoko'       ] = { 1, 10014, xi.guild.CLOTHCRAFT,   xi.skill.CLOTHCRAFT,   xi.effect.CLOTHCRAFT_IMAGERY   }, -- Free
            ['Anillah'       ] = { 2, 10015, xi.guild.CLOTHCRAFT,   xi.skill.CLOTHCRAFT,   xi.effect.CLOTHCRAFT_IMAGERY   }, -- Free
            ['Orechiniel'    ] = { 0,   650, xi.guild.LEATHERCRAFT, xi.skill.LEATHERCRAFT, xi.effect.LEATHERCRAFT_IMAGERY }, -- Advanced
            ['Kipopo'        ] = { 1,   651, xi.guild.LEATHERCRAFT, xi.skill.LEATHERCRAFT, xi.effect.LEATHERCRAFT_IMAGERY }, -- Free
            ['Tek_Lengyon'   ] = { 2,   652, xi.guild.LEATHERCRAFT, xi.skill.LEATHERCRAFT, xi.effect.LEATHERCRAFT_IMAGERY }, -- Free
            ['Lih_Pituu'     ] = { 0, 10018, xi.guild.BONECRAFT,    xi.skill.BONECRAFT,    xi.effect.BONECRAFT_IMAGERY    }, -- Advanced
            ['Ronana'        ] = { 1, 10019, xi.guild.BONECRAFT,    xi.skill.BONECRAFT,    xi.effect.BONECRAFT_IMAGERY    }, -- Free
            ['Kyaa_Taali'    ] = { 2, 10020, xi.guild.BONECRAFT,    xi.skill.BONECRAFT,    xi.effect.BONECRAFT_IMAGERY    }, -- Free
            ['Azima'         ] = { 0,   122, xi.guild.ALCHEMY,      xi.skill.ALCHEMY,      xi.effect.ALCHEMY_IMAGERY      }, -- Advanced
            ['Titus'         ] = { 1,   123, xi.guild.ALCHEMY,      xi.skill.ALCHEMY,      xi.effect.ALCHEMY_IMAGERY      }, -- Free
            ['Sieglinde'     ] = { 2,   124, xi.guild.ALCHEMY,      xi.skill.ALCHEMY,      xi.effect.ALCHEMY_IMAGERY      }, -- Free
            ['Kipo-Opo'      ] = { 0, 10015, xi.guild.COOKING,      xi.skill.COOKING,      xi.effect.COOKING_IMAGERY      }, -- Advanced
            ['Jacodaut'      ] = { 1, 10016, xi.guild.COOKING,      xi.skill.COOKING,      xi.effect.COOKING_IMAGERY      }, -- Free
            ['Hakeem'        ] = { 2, 10017, xi.guild.COOKING,      xi.skill.COOKING,      xi.effect.COOKING_IMAGERY      }, -- Free
        }
        local effectId = 0
        for _, npcData in pairs(npcTable) do
            if npcData[1] == 0 and npcData[4] == skillID then
                effectId = npcData[5]
                break
            end
        end

        if effectId > 0 then
            player:delStatusEffectsByFlag(xi.effectFlag.SYNTH_SUPPORT, true)
            player:addStatusEffect(effectId, 3, 0, 480)
        end

        local stock = xi.shop.generalGuildStock[skillID]
        xi.shop.generalGuild(player, stock, skillID)
    end

    local vendorList = {}

    for _, skillID in pairs(skills) do
        table.insert(vendorList, { xi.skillName[skillID], skillID })
    end


    table.insert(menuOptions.options, {
        "Guild Shops",
        function()
            cexi.util.simpleMenu(player, npc, vendorList, showVendor, "Choose a Guild:")
        end,
    })

    delaySendMenu(player, menuOptions)
end

local entity   =
{
    {
        id        = REGAL_PAWPRINT,
        name      = RegalPawprint,
        marker    = cq.MAIN_QUEST,
        area      = "Lower_Jeuno",
        pos       = { -53.788, 6.000, -62.833, 40 }, -- !pos -53.788 6.000 -62.833 245
        hideName  = true,
        dialog    =
        {
            NAME    = false,
            DEFAULT = function(player)
                        pawprintDefault(player)
                      end,
        },
    },
    {
        id        = CAIT_SITH,
        name      = CaitSith,
        type      = xi.objType.NPC,
        look      = 2197,
        notarget  = true,
        area      = "Lower_Jeuno",
        pos       = { -53.788, 6.000, -62.833, 40 }, -- !pos -53.788 6.000 -62.833 245
        hideName  = true,
        hidden    = true,
    },
    {
        id          = RIPPED_BARK,
        name        = RippedBark,
        marker      = cq.MAIN_QUEST,
        area        = "East_Ronfaure_[S]",
        pos         = { 393.844, -39.412, 18.503, 142 }, -- !pos 393.844 -39.412 18.503 81
        widescan    = 1,
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id        = LILISETTE_CS,
        name      = Lilisette,
        type      = xi.objType.NPC,
        look      = 2191,
        notarget  = true,
        area      = "East_Ronfaure_[S]",
        pos       = { 395.838, -39.764, 20.207, 139 }, -- !pos 395.838 -39.764 20.207 81
        hideName  = true,
        hidden    = true,
    },
    {
        id          = MAGIC_LILY_PAD,
        name        = MagicLilyPad,
        marker      = cq.SIDE_QUEST,
        area        = "Pashhow_Marshlands_[S]",
        pos         = { 147.375, 26.330, -411.656, 121 }, -- !pos 141.956, 24.212, -411.924 90
        widescan    = 1,
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id        = "POROGGO_KING",
        name      = "Poroggo King",
        type      = xi.objType.NPC,
        look      = 1813,
        notarget  = true,
        area      = "Pashhow_Marshlands_[S]",
        pos       = { 143.453, 21.754, -416.073, 195 }, -- !pos 143.453 21.754 -416.073 195
        hideName  = true,
        hidden    = true,
    },
    {
        id        = "POROGGO_CONSORT",
        name      = "Poroggo Consort",
        type      = xi.objType.NPC,
        look      = 1811,
        notarget  = true,
        area      = "Pashhow_Marshlands_[S]",
        pos       = { 142.189, 21.683, -417.328, 178 }, -- !pos 142.189 21.683 -417.328 90
        hideName  = true,
        hidden    = true,
    },
    {
        id        = "POROGGO_ADVISOR",
        name      = "Poroggo Advisor",
        type      = xi.objType.NPC,
        look      = 1811,
        notarget  = true,
        area      = "Pashhow_Marshlands_[S]",
        pos       = { 144.833, 21.673, -417.556, 192 }, -- !pos 146.114 21.579 -419.361 206
        hideName  = true,
        hidden    = true,
    },
    {
        id          = SPECTRAL_RIFT,
        name        = "Spectral Rift",
        marker      = cq.SIDE_QUEST,
        area        = "Meriphataud_Mountains_[S]",
        pos         = { 799.577, -17.036, 648.392, 60 }, -- !pos 799.577 -17.036 648.39 97
        widescan    = 1,
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },
    {
        id        = REGAL_UPPER,
        name      = RegalPawprint,
        marker    = cq.MAIN_QUEST,
        area      = "Upper_Jeuno",
        pos       = { -78.960, -1.200, 61.788, 69 }, -- !pos -78.960 -1.200 61.788 244
        hideName  = true,
        dialog    =
        {
            NAME    = false,
            DEFAULT = cq.NOTHING,
        },
    },
    {
        id        = CAIT_SITH_UPPER,
        name      = CaitSith,
        type      = xi.objType.NPC,
        look      = 2197,
        notarget  = true,
        area      = "Upper_Jeuno",
        pos       = { -78.741, -1.210, 60.213, 73 }, -- !pos -78.741 -1.210 60.213 244
        hideName  = true,
        hidden    = true,
    },
    {
        id          = LIBRARIAN,
        name        = "Librarian",
        type        = xi.objType.NPC,
        look        = cexi.util.look({
            race = xi.race.ELVAAN_F,
            face = cexi.face.A6,
            head = 119, -- Magnifying Spectacles,
            body = cexi.model.BLACK_MAGE_ARTIFACT,
            hand = cexi.model.BLACK_MAGE_ARTIFACT,
            legs = cexi.model.BLACK_MAGE_ARTIFACT,
            feet = cexi.model.BLACK_MAGE_ARTIFACT,
        }),
        area        = "Celennia_Memorial_Library",
        pos         = { -91.801, -2.189, -91.491, 116 }, -- !pos -98.165 -2.150 -96.991 284
        dialog      =
        {
            DEFAULT = function(player)
                        librarianDefault(player)
                      end,
        },
    },
    {
        id          = SEALED_BOOK,
        name        = SealedBook,
        type        = xi.objType.NPC,
        look        = 2809,
        hideName    = true,
        area        = "Celennia_Memorial_Library",
        pos         = { -103.648, -2.150, -84.201, 57 }, -- !pos -98.165 -2.150 -96.991 284
        dialog      =
        {
            DEFAULT = cq.NOTHING,
        },
    },
    {
        id        = CAIT_SITH,
        name      = CaitSith,
        type      = xi.objType.NPC,
        look      = 2197,
        notarget  = true,
        area      = "Celennia_Memorial_Library",
        pos       = { -103.648, -2.150, -84.201, 57 }, -- !pos -98.165 -2.150 -96.991 284
        namevis   = 0x80, -- Ghost
        hideName  = true,
        hidden    = true,
    },
    {
        id          = GWEN,
        name        = Gwendolen,
        type        = xi.objType.NPC,
        look        = cexi.util.look({
            race = xi.race.HUME_F,
            face = cexi.face.A4,
            main = 344,
            offh = 789,
            head = 125,
            body = 401,
            hand = 184,
            legs = 184,
            feet = 88,
        }),
        area        = "Celennia_Memorial_Library",
        pos         = { -105.323, -2.150, -84.247, 40 }, -- !pos -98.165 -2.150 -96.991 284
        namevis   = 0x80, -- Ghost
        hideName  = true,
        hidden    = true,
    },
    {
        id        = MYSTERIOUS_VOICE,
        name      = MysteriousVoice,
        type      = xi.objType.NPC,
        look      = 2492,
        notarget  = true,
        area      = "Celennia_Memorial_Library",
        pos       = { -105.323, -2.150, -84.247, 40 }, -- !pos -98.165 -2.150 -96.991 284
        hideName  = true,
        hidden    = true,
    },
    {
        id          = MISSING_PAGE_1,
        name        = "Missing Page",
        marker      = cq.SIDE_QUEST,
        area        = "Beaucedine_Glacier_[S]",
        pos         = { 268.399, -0.895, 251.446, 67 }, -- !pos 268.399 -0.895 251.446 136
        widescan    = 1,
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            COLLECT = collectPage,
        },
    },
    {
        id          = MISSING_PAGE_2,
        name        = "Missing Page",
        marker      = cq.SIDE_QUEST,
        area        = "Vunkerl_Inlet_[S]", -- (K-6)
        pos         = { 399.322, -32.008, 357.102, 0 }, -- !pos 399.322 -32.008 357.102 83
        widescan    = 1,
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            COLLECT = collectPage,
        },
    },
    {
        id          = MISSING_PAGE_3,
        name        = "Missing Page",
        marker      = cq.SIDE_QUEST,
        area        = "North_Gustaberg_[S]", -- (I-6)
        pos         = { 196.791, -20.242, 680.387, 140 }, -- !pos 196.791 -20.242 680.387 88
        widescan    = 1,
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
            COLLECT = collectPage,
        },
    },
    {
        id          = OMINOUS_SHADOW,
        name        = "Ominous Shadow",
        marker      = cq.MAIN_QUEST,
        area        = "Escha_RuAun",
        pos         = { 134.013, -32.326, -205.611, 167 }, -- !pos 134.013 -32.326 -205.611 289
        widescan    = 1,
        dialog      =
        {
            DEFAULT = cq.NOTHING,
            AFTER   = cq.NOTHING_ELSE,
        },
    },

    mobs.ORCISH_BRUTE,
    mobs.POROGGO_HERMIT,
    mobs.CHAOS_AEONDRAKE,
    mobs.VAMPYR,
}

local function npcDialog(tbl, npc, spawner)
    local result = {}

    local before =
    {
        { despawn = { spawner } },
        { spawn   = { npc } },
        { delay   = 500 },
        { entity  = npc, face = "player" },
        { delay   = 500 },
    }

    local after =
    {
        { delay   = 500 },
        { despawn = { npc } },
        { spawn   = { spawner } },
    }

    for _, line in pairs(before) do
        table.insert(result, line)
    end

    for _, line in pairs(tbl) do
        table.insert(result, line)
    end

    for _, line in pairs(after) do
        table.insert(result, line)
    end

    return result
end

local function caitDialog(tbl)
    return npcDialog(tbl, CaitSith, RegalPawprint)
end

local function libcaitDialog(tbl)
    return npcDialog(tbl, CaitSith, SealedBook)
end

local function liliDialog(tbl)
    return npcDialog(tbl, Lilisette, RippedBark)
end

local domainBosses =
{
    "[DI]Colkhab_kills",
    "[DI]Tchakka_kills",
    "[DI]Achuka_kills",
    "[DI]Yumcax_kills",
    "[DI]Hurkan_kills",
    "[DI]Kumhau_kills",
}

local goblinDailies =
{
    "[DQ]Fishstix_complete",
    "[DQ]Saltlix_complete",
    "[DQ]Beetrix_complete",
}

local TASKS_BEGINNER =
{
    { "[CQ]MARCEO_FISH",     10, "Gut 10 fish at Marceo in Norg"                           },
    { "[CW]EMILIA",           1, "Unlock Emilia's Outpost services in Lower Jeuno"         },
    { "[CW]DOMENIC",          1, "Unlock Domenic's services in Lower Jeuno"                },
}

local TASKS_INTERMEDIATE =
{
    { "[CQ]NOVICE_TRIALS",       3, "Complete 3 Novice Trials from Mellie in Selbina"         },
    { "[GARRISON]POINTS",      800, "Earn 800 Garrison Points participating in Garrison"      },
    { "[SKILL]Garbagio_Tally",   3, "Feed 3 items to Garbagio in Port Jeuno"                  },
}

local TASKS_ADVANCED =
{
    { goblinDailies,          1, "Complete Goblin Daily Quests: Fishtix, Saltlix, Beetrix" },
    { domainBosses,           1, "Defeat 6 Domain Invasion bosses"                         },
    { "[NEO]RP_BALANCE",    500, "Earn 500 RP inside Dynamis"                              },
}

local mission =
{
    "Broken Wings",          -- 1
    "Ethereal Echo",         -- 2
    "Flying Start",          -- 3
    "Break a Leg",           -- 4
    "Trial by Tango",        -- 5
    "Taking Flight",         -- 6
    "Light of Dawn",         -- 7
    "Cait and Mouse",        -- 8
    "Spirited Away",         -- 9
    "Ghosts of the Past",    -- 10
    "Claws of Captivity",    -- 11
    "Fly Again",             -- 12
    "Echoes of Renewal",     -- 13
    "Swooping Frenzy",       -- 14
    "Diamond in the Rough",  -- 15
    "Final Descent",         -- 16
    "Mended Wings",          -- 17
}

local step =
{
    -----------------------------------
    -- Mission #1 - Broken Wings
    -- !setvar [CQ]WINGS_ERA_WARRIOR 0
    -- !pos -53.788 6.000 -62.833 245
    -----------------------------------
    {
        check   = cq.checks({ WEW = true }),
        [REGAL_PAWPRINT] = cq.dialog({
            mission = mission[1],
            name    = CaitSith,
            event   =
            {
                { music   = 297 },
                { despawn = { RegalPawprint } },
                { spawn   = { CaitSith } },
                { delay   = 1000 },
                { entity = CaitSith, animate = 170, mode = 4 },
                { delay  = 5000 },
                { entity  = CaitSith, face = "player" },
                "Nyan! Can you see me, adventurer? Am I apparent?",
                { delay = 500 },
                " Thank goodness you found me. You located this cat.",
                { entity = CaitSith, packet = "sp00" },
                { delay  = 2000 },
                { entity  = CaitSith, face = "player" },
                " I was thinking no one would notice me in this world. This bewildering expanse.",
                { entity = CaitSith, animate = 72, mode = 1 }, -- Zzz
                { delay = 1000 },
                "I'm exceedingly exhausted! Quite lacking of energy.",
                { delay = 3000 },
                { entity  = CaitSith, face = "player" },
                "Will you be of desperately needed assistance? Of vital aid to this friendly feline?",
                " Required relief for an accidental acquaintance of sorts.",
                { delay   = 500 },
                { despawn = { CaitSith } },
                { music   = 293 },
                { animate = 165, mode = 3 },
                { delay   = 12000 },
                { music   = cexi.music.JEUNO },
                { spawn   = { RegalPawprint } },
            },
        }),
    },

    -----------------------------------
    -- Mission #2 - Ethereal Echo
    -- Reward: Icarus Wing
    -- !setvar [CQ]WINGS_ERA_WARRIOR 1
    -- !pos -53.788 6.000 -62.833 245
    -----------------------------------
    {
        [REGAL_PAWPRINT] = cq.menu({
            mission = mission[2],
            name    = CaitSith,
            title   = "Agree to help the cat?",
            options =
            {
                {
                    "I'm allergic!",
                },
                {
                    "What could go wrong?",
                    caitDialog({
                        { entity = CaitSith, animate = 250, mode = 4 }, -- Lightbulb
                        "If I had in my posession an Ether... A potion of magical effect...",
                        " Purrhaps I'd regain enough power to return back home. The place where I belong.",
                        "What do you say, Adventurer? Brave one who goes forth into the unknown.",
                    }),
                },
            },
        }),
    },
    {
        [REGAL_PAWPRINT] =
        {
            onTrigger = cq.dialog({
                name  = CaitSith,
                step  = false,
                event = caitDialog({
                    "If only I had in my posession an Ether... A magical potion.",
                }),
            }),

            onTrade   = cq.trade({
                mission  = mission[3],
                name     = CaitSith,
                required = xi.item.ETHER,
                reward   = xi.item.ICARUS_WING,

                accepted = caitDialog({
                    { music  = 297 },
                    "Oh, will this marvellous medicament be the remedy for my perilous predicament?",
                    { entity = CaitSith, packet = "sp00" },
                    " A solution to this situation most unfavorable?",
                    { entity = CaitSith, animate = 32, mode = 1 },
                    { delay  = 5000 },
                    "Now, I've recovered a little, recuperated slightly. Here goes!",
                    { entity = CaitSith, packet = "sp00" },
                    { entity = CaitSith, animate = 248 },
                    { delay  = 5000 },
                    "...",
                    { delay = 500 },
                    "Well... Still at your side, I am. That is, entirely present.",
                    { delay  = 2000 },
                    "If my stay be extended, perhaps of this world, I should understand a little more. Increase in comprehension",
                    " Will you be my guide on this expedition? Captain of this voyage?",
                    { music = cexi.music.JEUNO },
                }),

                declined = caitDialog({
                    "If only I had in my posession of an Ether... A magical potion.",
                }),
            }),
        },
    },

    -----------------------------------
    -- Mission #3 - Flying Start
    -- Reward: Talaria
    -- !setvar [CQ]WINGS_ERA_WARRIOR 3
    -- !pos -53.788 6.000 -62.833 245
    -----------------------------------
    {
        [REGAL_PAWPRINT] = cq.task({
            name     = CaitSith,
            tasklist = TASKS_BEGINNER,
            reward   = 11403, -- Talaria
            wrapper  = caitDialog,

            accepted = caitDialog({
                "That explains a few things. Makes digestable an array of affairs. ",
                { face = "player" },
                "I think you and I have earned quite the respite. A recess if you will.",
                " Do tell when you're ready to continue. To resume with matters.",
            }),

            reminder =
            {
                "Here's a few tasks, things to see and do:",
            },
        }),
    },

    -----------------------------------
    -- Mission #4 - Break a Leg
    -- !setvar [CQ]WINGS_ERA_WARRIOR 4
    -- Regal Pawprint !pos -53.788 6.000 -62.833 245
    -- Ripped Bark    !pos 393.844 -39.412 18.503 81
    -----------------------------------
    {
        [REGAL_PAWPRINT] = cq.menu({
            mission = mission[4],
            name    = CaitSith,
            title   = "Are you ready to continue?",
            options =
            {
                {
                    "Not yet",
                },
                {
                    "I'm ready",
                    caitDialog({
                        "Ever the curious, this cait has a feeling of something afoot in the past.",
                        " A premonition of some peculiar happening gone by.",
                        "You may find someone or something to aid us where the river forks in East Ronfaure [S].",
                        " Where one stream diverges and two waters proceed.",
                    }),
                },
            },
        }),
    },
    { -- !setvar [CQ]WINGS_ERA_WARRIOR 5
        [REGAL_PAWPRINT] = cq.dialog({
            name  = CaitSith,
            step  = false,
            event = caitDialog({
                "You may find someone or something to aid us where the river forks in East Ronfaure [S].",
                " Where water diverges and two streams proceed.",
            }),
        }),

        [RIPPED_BARK]    = cq.menuSpawn(ORCISH_BRUTE, "Look closer?", { { "Barking up the wrong tree" }, { "Let's dance" } }, 2),
        [ORCISH_BRUTE]   = cq.killStep(RIPPED_BARK),
    },

    -----------------------------------
    -- Mission #5: Trial by Tango
    -- !setvar [CQ]WINGS_ERA_WARRIOR 6
    -- Ripped Bark    !pos 393.844 -39.412 18.503 81
    -----------------------------------
    {
        [RIPPED_BARK] = cq.dialog({
            mission = mission[5],
            name    = Lilisette,
            event   = liliDialog({
                { music  = 145 },
                { delay  = 1000 },
                { entity = Lilisette, packet = "shit" },
                "Hold up! Just who are you?",
                { delay = 2000 },
                { entity = Lilisette, face = "player" },
                " ...Future Vana'diel? Saving a friend? You want my help?",
                { delay = 2000 },
                { entity = Lilisette, face = "player" },
                "Slow down. Listen here, you sound a little crazy but...",
                " If you are capable of performing a routine or two then I'll hear you out!",
                { music  = 251 }, -- East Ronfaure [S]
            }),
        }),
    },
    {
        [RIPPED_BARK] = cq.task({
            mission  = mission[6],
            name     = Lilisette,
            tasklist = TASKS_INTERMEDIATE,
            reward   = 11666, -- Novennial Ring
            wrapper  = liliDialog,

            accepted = liliDialog({
                { music  = 145 },
                { entity = Lilisette, packet = "ati0", target = RippedBark },
                "Well, well, well. You really showed up.",
                " I believe you and this strange cat.",
                { delay = 1000 },
                { entity = Lilisette, face = "player" },
                "I've asked the troupe and it may just be a rumor but...",
                { delay = 500 },
                "They say there's a toad in Pashhow Marshlands [S] that can travel between worlds!",
                { delay = 500 },
                { entity = Lilisette, face = "player" },
                " What! Don't look at me like that. It's not any more wild than what you said!",
                { delay = 2000 },
                { entity = Lilisette, face = "player" },
                "Anyway, find that toad and maybe you can help your furry friend.",
                " I've heard it lives on a magic lily pad... That's all I've got for you!",
                { music  = 251 }, -- East Ronfaure [S]
            }),

            reminder =
            {
                "Show me you're not just all talk. See if you can handle this:",
            },
        }),
    },

    -----------------------------------
    -- Mission #6: Taking Flight
    -- !setvar [CQ]WINGS_ERA_WARRIOR 8
    -- Magic Lily Pad !pos 141.956, 24.212, -411.924 90
    -----------------------------------
    {
        [RIPPED_BARK] = cq.dialog({
            name    = Lilisette,
            step    = false,
            event   = liliDialog({
                "Maybe if you find that toad in Pashhow, you can help your furry friend.",
                " I've heard it lives on a magic lily pad... That's all I've got for you!"
            }),
        }),

        [MAGIC_LILY_PAD] = cq.menuSpawn(POROGGO_HERMIT, "Lily, set, go!?", { { "Croak" }, { "Hop to it" } }, 2),
        [POROGGO_HERMIT] = cq.killStep(MAGIC_LILY_PAD, nil, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "AWR_POROGGO" }),
    },
    {
        [MAGIC_LILY_PAD] = cq.dialog({
            mission = mission[7],
            event   =
            {
                { music   = 284 },
                { despawn = { MagicLilyPad } },
                { spawn   = { "Poroggo King", "Poroggo Consort", "Poroggo Advisor" } },
                { delay   = 1000 },
                { entity  = "Poroggo Consort", face = "player" },
                "Poroggo Consort : Reee!",
                { entity = "Poroggo_Consort", packet = "shot" },
                { entity = "Poroggo_Consort", animate = 255, mode = 4 },

                { entity  = "Poroggo Advisor", face = "player" },
                "Poroggo Advisor : Reeeee!",
                { entity = "Poroggo_Advisor", packet = "shot" },
                { entity = "Poroggo_Advisor", animate = 255, mode = 4 },

                { entity  = "Poroggo King", face = "player" },
                "Poroggo King : Reeee! Get away, get away! Outsider be gone!",
                { entity = "Poroggo_King", animate = 255, mode = 4 },
                { entity = "Poroggo_King", packet = "shot" },

                { entity  = "Poroggo Consort", face = "player" },
                "Poroggo Consort : Not welcome here!!",
                { delay = 5000 },

                "Poroggo King : ...Help? You must be truly desperate to come to me for help.",
                { delay = 2000 },
                "Poroggo King : Veryee well, I will listen to your request but FIRST you must bring us...",
                { delay = 1000 },

                { entity = "Poroggo_Consort", packet = "cni0" },
                "Poroggo Consort : Insect Wiinggs!",

                { entity = "Poroggo_Advisor", packet = "cni0" },
                "Poroggo Advisor : Ruusty Buckets!",

                { delay = 1000 },
                { entity = "Poroggo_King", packet = "ati1" },
                "Poroggo King : Silence!",

                { delay = 2000 },
                "Poroggo King : ...Hmm... what do we want?",
                { entity = "Poroggo_King", animate = 250, mode = 4 },
                " What would be really valuable?",
                { entity = "Poroggo_Consort", face = "Poroggo_King" },
                { entity = "Poroggo_Advisor", face = "Poroggo_King" },

                { delay = 2000 },

                { entity = "Poroggo_Consort", animate = 250, mode = 4 },
                "Poroggo Consort : A beautiful dress!",

                { entity = "Poroggo_Advisor", animate = 250, mode = 4 },
                "Poroggo Advisor : Gold!",

                { delay = 1000 },

                { entity = "Poroggo_King", animate = 250, mode = 4 },
                "Poroggo King : Fine. Bring us golden cloth and we'll listen to your request!",

                { delay   = 500 },
                { despawn = { "Poroggo King", "Poroggo Consort", "Poroggo Advisor" } },
                { spawn   = { MagicLilyPad } },
                { music   = 0 },
            },
        }),
    },

    -----------------------------------
    -- Mission #7: Light of Dawn
    -- !setvar [CQ]WINGS_ERA_WARRIOR 10
    -----------------------------------
    {
        [MAGIC_LILY_PAD] =
        {
            onTrigger = cq.dialog({
                name    = "Poroggo King",
                step    = false,
                event   =
                {
                    "Bring us golden cloth and we'll listen to your request!",
                },
            }),

            onTrade   = cq.trade({
                mission  = mission[8],
                required = 1844,             -- Spectral Goldenrod
                reward   = { { 5660, 12 } }, -- Pepperoni x12

                accepted =
                {
                    { music   = 284 },
                    { despawn = { MagicLilyPad } },
                    { spawn   = { "Poroggo King", "Poroggo Consort", "Poroggo Advisor" } },
                    { delay   = 1000 },
                    { entity  = "Poroggo Consort", face = "player" },

                    { entity = "Poroggo_Consort", packet = "shot" },
                    "Poroggo Consort : So pretty!",

                    { entity = "Poroggo_Advisor", packet = "shot" },
                    "Poroggo Advisor : We're rich!!",

                    { delay = 2000 },

                    "Poroggo King : Yes, yes. Now what do you want?",
                    { entity = "Poroggo_King", animate = 255, mode = 4 },
                    { delay = 2000 },
                    "Poroggo King : ... ",
                    { delay = 1000 },
                    "Poroggo King : A talking cat? Don't be ridiculous!",
                    { entity = "Poroggo_Advisor", packet = "cnf0" },
                    { delay = 500 },
                    "Poroggo Advisor : How dare you insult the king's intelligence!",
                    { delay = 1000 },
                    { entity = "Poroggo_King", packet = "shot" },
                    { entity = "Poroggo_King", animate = 255, mode = 4 },
                    "Poroggo King : Silence!",

                    "Poroggo King : Yes, I see... usually people can't pass between the worlds.",
                    " But there is another way.",
                    { delay = 2000 },
                    "Poroggo King : A book.",
                    { delay = 500 },

                    { entity = "Poroggo_Consort", packet = "shot" },
                    "Poroggo Consort : Book!",

                    { entity = "Poroggo_Advisor", packet = "shot" },
                    "Poroggo Advisor : Books!",

                    { delay = 2000 },

                    "Poroggo King : Yes, there is a magical book, a timelost tome.",
                    " Its magical words will take you to a place far away!",

                    { delay = 1000 },

                    "Poroggo King : We finished here. You leave now!",

                    { entity = "Poroggo_Consort", packet = "shot" },
                    { entity = "Poroggo_Advisor", packet = "shot" },
                    "Poroggo Consort : Leave!",
                    "Poroggo Advisor : Leave us!",

                    { delay   = 500 },
                    { despawn = { "Poroggo King", "Poroggo Consort", "Poroggo Advisor" } },
                    { spawn   = { MagicLilyPad } },
                    { music   = 0 },
                },

                declined =
                {
                    "Nothing happens.",
                },
            }),
        },
    },

    -----------------------------------
    -- Mission #8: Cait and Mouse
    -- !setvar [CQ]WINGS_ERA_WARRIOR 11
    -- Regal Pawprint !pos -53.788 6.000 -62.833 245
    -----------------------------------
    {
        [REGAL_PAWPRINT] = cq.dialog({
            name    = CaitSith,
            event   = caitDialog({
                "Nyan! You're back! You've returned!",
                { entity = CaitSith, packet = "sp00" },
                { delay  = 1000 },
                " Ah yes, there are such magical books, existent spellbound tomes.",
                { delay  = 2000 },
                "While you were gone, I poked my nose around, investigated the area.",
                " There seem to be a great many books in Upper Jeuno, let's begin searching there! Start scratching around!",
            }),
        }),
    },

    -----------------------------------
    -- Mission #9: Spirited Away
    -- !setvar [CQ]WINGS_ERA_WARRIOR 12
    -- !pos -64.562 -1.199 61.300 244
    -----------------------------------
    {
        [REGAL_PAWPRINT] = cq.dialog({
            name    = CaitSith,
            step    = false,
            event   = caitDialog({
                "There seem to be a great many books in Upper Jeuno, let's begin our search there! Start scratching around!",
            }),
        }),


        [REGAL_UPPER] = cq.dialog({
            mission = mission[9],
            name    = CaitSith,
            event   = caitDialog({
                { music = 70 },
                "Hmm... This looks like one of those magical books right here! Before us now.",
                " Well, let's open it. Time to turn the page...",
                { entity = CaitSith, face = "Timelost Tome" },
                { entity = player, animate = 96, mode = 4 }, -- Stars over screen
                { delay  = 3000 },
                { pos    = { -97.338, -2.150, -102.563, 160, 284 } },
            }),
        }),
    },

    -----------------------------------
    -- Mission #10: Ghosts of the Past
    -- !setvar [CQ]WINGS_ERA_WARRIOR 13
    -- !pos -96.497 -4.150 -103.405 284
    -----------------------------------
    {
        [LIBRARIAN] = cq.dialog({
            mission = mission[10],
            name    = "Librarian",
            event   =
            {
                { music = 69 },
                { emote = xi.emote.WELCOME },
                "It has been many years since we had a visitor.",
                " Allow me to share a little history.",
                { delay = 1000 },
                "Our world was once vast and overflowing with life. It was a place filled with excitement and adventure.",
                { emote = xi.emote.THINK },
                { delay = 2000 },
                " Now all that remains are these memories, countless records and tales of adventurers bygone.",
                { delay = 1000 },
                " Their feats, their struggles, their losses, their victories, their hopes and dreams.",
                "All have come to rest in this place, the last remnant of what was.",
            },
        }),
    },
    {   -- !setvar [CQ]WINGS_ERA_WARRIOR 14
        [LIBRARIAN] = cq.menu({
            name    = "Librarian",
            title   = "How did this happen?",
            options =
            {
                {
                    "Not interested",
                },
                {
                    "Tell me more",
                    {
                        "This world is no ordinary one, it was shaped by the hand of a mysterious \"author\".",
                        { emote = xi.emote.YES },
                        { delay = 1000 },
                        " Filling this world with colorful places and lively characters, joy and meaning was brought to all.",
                        " That was until...",
                        { delay = 2000 },
                        { emote = xi.emote.SIGH },
                        " One such creation was not content to be a mere side-character and wanted to take all for himself.",
                        { delay = 1000 },
                        " He escaped to the other side, imprisoning the author and began destroying each tome that bound our world.",
                        { emote = xi.emote.NO },
                        { delay = 2000 },
                        "The book you entered through is one of the last of such in existence.",
                    },
                },
            },
        }),
    },

    -----------------------------------
    -- Mission #11: Claws of Captivity
    -- !setvar [CQ]WINGS_ERA_WARRIOR 15
    -- !pos -96.497 -4.150 -103.405 284
    -----------------------------------
    {
        [LIBRARIAN] = cq.menu({
            name    = "Librarian",
            mission = mission[11],
            title   = "We're not done yet",
            options =
            {
                {
                    "I've heard enough",
                },
                {
                    "Where's the cat?",
                    {
                        "Ah, your feline friend came here too but...",
                        " It seems they were a little too into that book over there and became trapped between the lines!",
                        { emote = xi.emote.LAUGH },
                        "Then the book sealed itself shut! We'll need some powerful holy water to break its magic binding.",
                    },
                },
            },
        }),
    },
    {   -- !setvar [CQ]WINGS_ERA_WARRIOR 16
        [LIBRARIAN] = cq.menu({
            name    = "Librarian",
            title   = "Holy Water?",
            options =
            {
                {
                    "Not yet",
                },
                {
                    "How can I help?",
                    {
                        "I've tried in vain to break its spell with the aged holy water I have.",
                        { emote = xi.emote.NO },
                        " However, we're going to need something more potent to lift this curse.",
                    },
                },
            },
        }),
    },
    {   -- !setvar [CQ]WINGS_ERA_WARRIOR 17
        [LIBRARIAN] = cq.menu({
            name    = "Librarian",
            title   = "Lift the curse?",
            options =
            {
                {
                    "I'm out!",
                },
                {
                    "Tell me more",
                    {
                        "Some Yagudo priests are known to carry a stronger form of holy water that may just be enough.",
                        { emote = xi.emote.YES },
                        " I'll need both kinds just to be sure. Please bring me a Yagudo Holy Water and an Odious Holy Water.",
                        " Sorry, I do not know where you will find these but please return here as soon as you do!",
                    },
                },
            },
        }),
    },
    {   -- !setvar [CQ]WINGS_ERA_WARRIOR 18
        [LIBRARIAN] =
        {
            onTrigger = cq.dialog({
                name    = "Librarian",
                step    = false,
                event   =
                {
                    "I'll need both kinds just to be sure. Please bring me a Yagudo Holy Water and an Odious Holy Water.",
                    " Sorry, I do not know where you will find these but please return here as soon as you do!",
                },
            }),

            onTrade   = cq.trade({
                mission  = mission[12],
                name     = "Librarian",
                required = { { 1097, 1}, { 3390, 1 } }, -- Yagudo Holy Water, Odious Holy Water
                reward   = { { 4154, 6 } },

                accepted =
                {
                    "Meet me at the sealed book and we'll see if it can be cracked open.",
                },

                declined =
                {
                    "Hmmm... this isn't it. Please bring me a Yagudo Holy Water and an Odious Holy Water.",
                },
            }),
        },
    },

    -----------------------------------
    -- Mission #12: Fly Again
    -- !setvar [CQ]WINGS_ERA_WARRIOR 19
    -- !pos -96.497 -4.150 -103.405 284
    -----------------------------------
    {
        [SEALED_BOOK] = cq.dialog({
            mission = mission[12],
            event   =
            {
                "Librarian : Well, well, let's see...",
                { entity  = "Sealed Book", animate = 170, mode = 4 },
                { delay   = 3000 },
                { despawn = { "Sealed Book" } },
                { spawn   = { CaitSith } },
                { delay   = 500 },
                { entity  = CaitSith, face = "player" },
                "Regal Feline: Nyan! There you are! Here am I!",
                { entity = CaitSith, packet = "sp00" },
                { delay  = 2000 },
                " Ah yes, well it seems inside this book is one who can help.",
                { delay  = 2000 },
                " A powerful mage lives within... One to return me home, send me back.",
                { entity = CaitSith, animate = 250, mode = 4 }, -- Lightbulb
                { delay  = 2000 },
                "Regal Feline: But some pages are missing! Chapters gone! It's incomplete, lacking pieces.",
                { delay  = 3000 },
                " I'm told there's a missing page somewhere in Beaucedine Glacier [S], around a frozen lake that never thaws.",
                { despawn = { CaitSith } },
                { spawn   = { "Sealed Book" } },
            },
        }),
    },
    {   -- !pos 268.399 -0.895 251.446 136
        [SEALED_BOOK] = cq.dialog({
            name    = "Regal Feline",
            step    = false,
            event   = libcaitDialog({
                "I'm told there's a missing page somewhere in Beaucedine Glacier [S] around a frozen lake that never thaws.",
            }),
        }),
        [MISSING_PAGE_1] = cq.talkStep("COLLECT"),
    },
    {   -- !pos 399.322 -32.008 357.102 83
        [MISSING_PAGE_1] = cq.talkOnly("AFTER"),
        [SEALED_BOOK]    = cq.dialog({
            name    = "Regal Feline",
            step    = false,
            event   = libcaitDialog({
                "There's another page in Vunkerl Inlet [S] overlooking a lighthouse.",
            }),
        }),
        [MISSING_PAGE_2] = cq.talkStep("COLLECT"),
    },
    {   -- !pos 196.791 -20.242 680.387 88
        [MISSING_PAGE_2] = cq.talkOnly("AFTER"),
        [SEALED_BOOK]    = cq.dialog({
            name    = "Regal Feline",
            step    = false,
            event   = libcaitDialog({
                "Aha, a final missing piece, the last chapter. It's located in North Gustaberg [S] behind a watchtower on the hill.",
            }),
        }),
        [MISSING_PAGE_3] = cq.talkStep("COLLECT"),
    },
    {   -- !setvar [CQ]WINGS_ERA_WARRIOR 23
        [MISSING_PAGE_3] = cq.talkOnly("AFTER"),
        [SEALED_BOOK]    = cq.dialog({
            name    = CaitSith,
            reward  = { exp = 10000 },
            event   = libcaitDialog({
                "That's it! ",
                " Let's take a moment, a little rest, while I delve back into this text and read the rest.",
            }),
        }),
    },

    -----------------------------------
    -- Mission #13: Echoes of Renewal
    -- !setvar [CQ]WINGS_ERA_WARRIOR 24
    -- !pos -96.497 -4.150 -103.405 284
    -----------------------------------
    {
        [SEALED_BOOK]    = cq.dialog({
            name    = CaitSith,
            mission = mission[13],
            event   = libcaitDialog({
                "Oh fearsome foes indeed await us! Monstrous miscreations before our path!",
                " I think a little more preparation is in order, to ready ourselves for the coming battles.",
            }),
        }),
    },
    {
        [SEALED_BOOK] = cq.task({
            name     = CaitSith,
            tasklist = TASKS_ADVANCED,
            accepted = libcaitDialog({
                "Well then, for the mage to help us, we must restore a magical staff, renew a stick of sorcery.",
                " They say it all begins with a beleaguering bout against a disorderly dragon in Meriphataud Mountains [S]!",
                { entity = CaitSith, animate = 250, mode = 4 }, -- Lightbulb
                { delay = 2000 },
                " Apparently, only its dark beating heart *gulp* is enough to infuse the necessary qualities, the required particulars.",
                "Nyan, don't look at me like that! I'm just the messenger of this dreadful design! An unfortunate deliverer of this news most unpleasant!",
            }),

            reminder = libcaitDialog({
                "There's a little more for us to do, a few things to accomplish:",
            }),
        }),
    },

    -----------------------------------
    -- Mission #14: Swooping Frenzy
    -- !setvar [CQ]WINGS_ERA_WARRIOR 26
    -- !pos 799.577 -17.036 648.39 97
    -----------------------------------
    -- Notes: Meriphataud Mountains [S]
    {
        [SEALED_BOOK]    = cq.dialog({
            name    = "Regal Feline",
            step    = false,
            event   = libcaitDialog({
                "It all begins with a beleaguering bout against a disorderly dragon in Meriphataud Mountains [S]!",
            }),
        }),

        [SPECTRAL_RIFT]   = cq.menuSpawn(CHAOS_AEONDRAKE, "Are you ready?", { { "Not yet" }, { "Into battle" } }, 2),
        [CHAOS_AEONDRAKE] = cq.killStep(SPECTRAL_RIFT, nil, nil, { helper = xi.item.DRAGON_CHRONICLES, var = "AWR_AEONDRAKE" }),
    },

    -----------------------------------
    -- Mission #15: Diamond in the Rough
    -- !setvar [CQ]WINGS_ERA_WARRIOR 27
    -- !pos -96.497 -4.150 -103.405 284
    -----------------------------------
    -- !additem 1666
    {
        [SPECTRAL_RIFT] = cq.dialog({
            step    = false,
            event   = cq.NOTHING_ELSE,
        }),

        [SEALED_BOOK] = cq.dialog({
            mission = mission[15],
            reward  = { exp = 10000 },
            event   = libcaitDialog({
                "You vanquished the dragon! The beast is slain!",
                { entity = CaitSith, packet = "sp00" },
                " One more step until the mage's power is restored and brought back to greatness.",
                { delay = 2000 },
                { entity = CaitSith, animate = 250, mode = 4 }, -- Lightbulb
                "It seems this staff requires a crowning jewel, a splendid gem upon its peak.",
                " And that being a quite peculiar requirement, an exceedingly rare Chameleon Diamond.",
            }),
        }),
    },
    { -- !setvar [CQ]WINGS_ERA_WARRIOR 28
        [SEALED_BOOK] =
        {
            onTrigger = cq.dialog({
                name    = CaitSith,
                step    = false,
                event   = libcaitDialog({
                    "It seems this staff requires a crowning jewel, a splendid gem upon its peak.",
                    " And that being a quite peculiar requirement, an exceedingly rare Chameleon Diamond.",
                }),
            }),

            onTrade   = cq.trade({
                mission  = mission[16],
                required = { 1666 }, -- Chameleon Diamond
                accepted = libcaitDialog({
                    "Regal Feline: This it. The scepter is complete.",
                    { music = 293 },
                    { delay = 2000 },
                    " Now we begin. The real story unfolds.",
                    { entity = CaitSith, animate = 169, mode = 4 },
                    { delay = 5000 },

                    { spawn   = { MysteriousVoice } },
                    { delay   = 1500 },
                    { entity = MysteriousVoice, animate = 76, mode = 4 },

                    "Mysterious Voice : Adventurer, through your determination and courage, you've overcome many challenges.",
                    " There is but one final battle. You must face the very darkness that threatens this world.",
                    { delay = 3000 },

                    "Mysterious Voice : In the heart of the Eschan dimension, dwells a Vampyr Lord, drawing the energies from other worlds into his twisted designs.",
                    " This foul creature has eroded most of our world but his time is finally at an end.",
                    { delay = 3000 },

                    "Mysterious Voice : Put things right and I will use the last of my magic to send your friend home.",

                    { music = 63 },

                    { despawn   = { MysteriousVoice } },
                }),

                declined = libcaitDialog({
                    "It seems this staff requires a crowning jewel, a splendid gem upon its peak.",
                    " And that being a quite peculiar requirement, an exceedingly rare Chameleon Diamond.",
                }),
            }),
        },
    },

    -----------------------------------
    -- Mission #16: Final Descent
    -- !pos 133.508 -32.326 -204.614 289
    -- !setvar [CQ]WINGS_ERA_WARRIOR 29
    -----------------------------------
    -- Notes: Escha Ru'Aun
    {
        [SEALED_BOOK] = cq.dialog({
            step    = false,
            event   =
            {
                { despawn = { SealedBook } },
                { spawn   = { MysteriousVoice } },
                { delay   = 2000 },
                "Mysterious Voice : In the heart of the Eschan dimension, dwells a Vampyr Lord, drawing the energies from other worlds into his twisted designs.",
                " This foul creature has eroded most of our world but his time is finally at an end.",

                "Mysterious Voice : Put things right and I will use the last of my magic to send your friend home.",
                { despawn   = { MysteriousVoice } },
                { spawn   = { SealedBook } },
            },
        }),

        [OMINOUS_SHADOW] = cq.menuSpawn(VAMPYR, "A cold chill comes over you...", { { "Step away" }, { "Look closer" } }, 2),
        [VAMPYR]         = cq.killStep(OMINOUS_SHADOW, nil, nil, { helper = 8973, var = "AWR_VAMPYR" }), -- SP Gobbie Key
    },
    {
        [OMINOUS_SHADOW] = cq.dialog({
            step    = false,
            event   = cq.NOTHING_ELSE,
        }),

        -- !setvar [CQ]WINGS_ERA_WARRIOR 30
        -- !pos -96.497 -4.150 -103.405 284
        [SEALED_BOOK] = cq.dialog({
            reward  = { allied_notes = 30000 },
            mission = mission[17],
            event   =
            {
                { music = 69 },
                { despawn = { SealedBook } },
                { spawn   = { CaitSith } },
                { delay   = 500 },
                { entity  = CaitSith, face = "player" },
                { delay   = 1000 },
                { spawn   = { MysteriousVoice} },
                "Mysterious Voice : So it is done.",
                { delay   = 1000 },
                { spawn   = { Gwendolen } },
                { delay   = 1500 },
                { entity  = Gwendolen, animate = 38, mode = 4 },
                { delay   = 500 },
                { despawn = { MysteriousVoice } },
                { delay   = 2000 },
                { entity  = Gwendolen, face = "player" },
                { delay   = 2000 },
                "Gwendolen : The memories of this world can finally be at peace.",
                { entity  = Gwendolen, emote = xi.emote.YES },
                { delay = 3000 },
                " It is a bitter victory but one which ensures the future of our realm.",
                { delay = 3000 },

                { entity  = Gwendolen, face = "player" },
                "Gwendolen : On behalf of our world and all the memories that reside here, thank you adventurer.",
                { entity  = Gwendolen, animate = 47, mode = 4 },

                { delay = 8000 },

                { despawn = { Gwendolen } },

                { entity = CaitSith,  face = "player" },
                { delay  = 500 },
                { entity = CaitSith, packet = "sp00" },
                "Regal Feline : Psst. Meet me back in Jeuno. There's something I'd like to share with you...",

                { delay   = 2000 },
                { despawn = { CaitSith } },
                { spawn   = { SealedBook } },
            },
        }),
    },

    -----------------------------------
    -- Mission #17: Echoes of Renewal
    -- !pos -53.788 6.000 -62.833 245
    -- !setvar [CQ]WINGS_ERA_WARRIOR 31
    -----------------------------------
    {
        [SEALED_BOOK] = cq.dialog({
            step    = false,
            event   = cq.NOTHING_ELSE
        }),

        [REGAL_PAWPRINT] = cq.dialog({
            name    = CaitSith,
            reward  = 26944, -- Tartarus Platemail
            event   = caitDialog({
                { music   = 297 },
                "What a journey it has been. After all this adventure I almost forgot the reason it began.",
                { delay = 1000 },
                " The truth is, I've begun to feel at home here. A place I can belong anew.",
                { entity = CaitSith, packet = "sp00" },
                { delay = 3000 },

                "It would be fair to say, you've surpassed all my expectations, you've truly earned your wings.",
                { delay = 1000 },
                { entity  = CaitSith, face = "player" },
                " As a parting gesture, I'd like to bestow this gift upon you. Welcome home.",
                { music  = 201 },
                { entity = CaitSith, animate = 107, mode = 1 },
                { message = "\129\154 Completed: A Winged Resurgence \129\154" },
                { delay = 5000 },
            }),
        }),
    },
}

cexi.questMeta = cexi.questMeta or {}
cexi.questMeta.awr = cexi.questMeta.awr or {}

cexi.questMeta.awr.step = step
cexi.questMeta.awr.entity = entity

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
