-----------------------------------
-- AWR NM Skills
-- (Temporary)
-----------------------------------
require("modules/module_utils")
require("scripts/globals/mobskills")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("awr_nm_skills")

local skills =
{
    ["bloody_beak"] = function(target, mob, skill)
        local dmgmod = 1
        local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.WIND, dmgmod, xi.mobskills.magicalTpBonus.MAB_BONUS, 1)
        local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WIND, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
        skill:setMsg(xi.mobskills.mobPhysicalDrainMove(mob, target, skill, xi.mobskills.drainType.HP, dmg))
        return dmg
    end,

    ["calamitous_wind"] =
    {
        onMobSkillCheck = function(target, mob, skill)
            if mob:getHPP() > 50 then
                return 1
            else
                return 0
            end
        end,

        onMobWeaponSkill = function(target, mob, skill)
            local dmgmod = 1
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 4, xi.element.WIND, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WIND, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

            -- TODO: Should print *each* effect dispelled in addition to damage taken.
            target:dispelAllStatusEffect(bit.bor(xi.effectFlag.DISPELABLE, xi.effectFlag.FOOD))
            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WIND)

            return dmg
        end,
    },

    ["feral_peck"] = function(target, mob, skill)
        local currentHP = target:getHP()
        local damage    = currentHP

        -- if have more hp then 30%, then reduce to 10%
        if currentHP / target:getMaxHP() > 0.2 then
            damage = currentHP * .90
        end

        local dmg = xi.mobskills.mobFinalAdjustments(damage, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.PIERCING, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)

        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.PIERCING)

        return dmg
    end,

    ["storm_wing"] = function(target, mob, skill)
        xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.SILENCE, 1, 0, 60)
        local dmgmod = 3
        local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 1.5, xi.element.WIND, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
        local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WIND, xi.mobskills.shadowBehavior.NUMSHADOWS_3)
        target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WIND)
        return dmg
    end,

    ["tail_lash"] =
    {
        onMobSkillCheck = function(target, mob, skill)
            if not target:isBehind(mob, 48) then
                return 1
            end

            return 0
        end,

        onMobWeaponSkill = function(target, mob, skill)
            local numhits = 1
            local accmod = 1
            local dmgmod = 3
            local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, xi.mobskills.shadowBehavior.NUMSHADOWS_2)
            xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, xi.effect.AMNESIA, 1, 0, 60)
            target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
            return dmg
        end,
    },
}

for skillName, skillFunc in pairs(skills) do
    local skillPath = string.format("xi.actions.mobskills.%s", skillName)
    xi.module.ensureTable(skillPath)

    if type(skillFunc) == "table" then
        m:addOverride(skillPath .. ".onMobWeaponSkill", skillFunc.onMobWeaponSkill)
        m:addOverride(skillPath .. ".onMobSkillCheck",  skillFunc.onMobSkillCheck)

    else
        m:addOverride(skillPath .. ".onMobWeaponSkill", skillFunc)
        m:addOverride(skillPath .. ".onMobSkillCheck", function(target, mob, skill)
            return 0
        end)
    end
end

return m
