-----------------------------------
-- Aspects of Provenance
-----------------------------------
require("modules/module_utils")
require('scripts/globals/utils')
require('scripts/globals/player')
require('scripts/globals/npc_util')
local cq = require("modules/catseyexi/lua/additive_overrides/utils/custom_quest")
-----------------------------------
local m = Module:new("addon_aspects_of_provenance")

local info =
{
    name   = "Aspects of Provenance",
    author = "Loxley",
    var    = "[CW]ASPECTS_OF_PROVENANCE",
}

local CRYSTAL_ANOMALY = "CRYSTAL_ANOMALY"
local CrystalAnomaly  = "Crystal Anomaly"

local entity   =
{
    {
        id        = CRYSTAL_ANOMALY,
        name      = CrystalAnomaly,
        marker    = cq.MAIN_QUEST,
        area      = "Provenance",
        pos       = { 495.378, 27.500, -461.160, 38 }, -- !pos 495.378 27.500 -461.160 222
        hideName  = true,
        dialog    =
        {
            NAME    = false,
            DEFAULT = cq.NOTHING,
        },
    },
}

local mission =
{
    "Epilogue",
}

local step =
{
    -----------------------------------
    -- Placeholder
    -- Prevents missions from being accessed by players
    -----------------------------------
    {
        [CRYSTAL_ANOMALY] = cq.talkOnly("DEFAULT"),
    },

    -----------------------------------
    -- Mission #1 - ???
    -- !setvar [CW]ASPECTS_OF_PROVENANCE 0
    -- !pos 495.378 27.500 -461.160 222
    -----------------------------------
    {
        [CRYSTAL_ANOMALY] = cq.dialog({
            mission = mission[1],
            check   = { cw = true, level = 40 },
            name    = "Petros",
            event   =
            {
                { music   = 297 },
                { despawn = { CrystalAnomaly } },
                { entity = "Petros", face = "player"},
                "Adventurer, something feels different.",
                " The light of the crystals... something is amiss.",
                { delay = 1000 },
                "We must meet with the other keepers and find the source of this disturbance.",
                " Unfortunately, after thousands of years, our usual means of travel has fallen into disrepair",
                { delay = 1000 },
                "To bring this Provenance Crystal back online, requires resources I have not in this realm.",
                -- TODO:
                { music   = 293 },
                { entity  = player, animate = 164, mode = 3 },
                { delay   = 12000 },
                { music   = cexi.music.PROVENANCE },
                { spawn   = { CrystalAnomaly } },
            },
        }),
    },
}

cq.add(m, {
    info   = info,
    entity = entity,
    step   = step,
})

return m
