## Wiki Regex
Regex to convert lua tables into bg-wiki tables


### Fishing Ventures
```re
\s+{\s+\d+,\s+\"([A-Za-z\.\' ]+)\",\s+(\d+),\s+(\d+)\s+},
```

```re
| {{ItemIcon|$1|22}} [[$1]]
| $3
| $2
|-
```

### HELM Ventures
```re
\s+{\s+\d+,\s+"([A-Za-z\.\' ]+)",\s+(\d+)\s+},
```

```re
| {{ItemIcon|$1|22}} [[$1]]
| $2
| 
|-
```

### Crystal Warrior Ametrine
```re
    \-\- ([A-Za-z \(\)\']+)
    \[\d+\] \=
    \{
        name \= \"([A-Za-z \(\)\']+)\",
        hq   \= \{ \d+, \"([A-Za-z0-9\+ \(\)\']+)\" \},
        mats \= \{ { \d+, \d+ \}, \"([A-Za-z0-9 \(\)\']+)\" \},
    \},
```

```re
|-
| {{ItemIcon|$2|22}} {{tooltip|text=[[$2]]|tooltip=[[File:$2 description.png]]}}
| $1
| {{ItemIcon|$3|22}} {{tooltip|text=[[$3]]|tooltip=[[File:$3 description.png]]}}
| {{ItemIcon|$4|22}} {{tooltip|text=[[$4]]|tooltip=[[File:$4 description.png]]}}
```

### Campaign
#### Uppercase mob ID list
```re
( +)([A-Za-z_]+)( +)=
```

```re
$1\U$2$3=
```
