-----------------------------------
-- Commmand: !present
-- Find the seasonal event "Lost Present"
-----------------------------------
local commandObj = {}

commandObj.cmdprops =
{
    permission = 0,
    parameters = ''
}

local function validZone(zoneID)
    return
        zoneID == xi.zone.SOUTH_GUSTABERG or
        zoneID == xi.zone.EAST_RONFAURE or
        zoneID == xi.zone.WEST_SARUTABARUTA or
        zoneID == xi.zone.NORTH_GUSTABERG or
        zoneID == xi.zone.EAST_SARUTABARUTA or
        zoneID == xi.zone.WEST_RONFAURE
end

commandObj.onTrigger = function(player)
    if not validZone(player:getZoneID()) then
        player:printToPlayer("You can't use that in the current area.", xi.msg.channel.NS_SAY)
        return
    end


    local zone     = player:getZone()
    local npcTable = {}
    for _, npc in pairs(zone:queryEntitiesByName("DE_Lost Present")) do
        table.insert(npcTable, npc)
    end

    for _, npc in pairs(zone:queryEntitiesByName("DE_Twinkle Treant")) do
        table.insert(npcTable, npc)
    end

    local npcObj   = nil

    for _, npc in pairs(npcTable) do
        if npc:getStatus() ~= xi.status.DISAPPEAR then
            npcObj = npc
            break
        end
    end

    if npcObj == nil then
        player:printToPlayer("You sense nothing at this moment.", xi.msg.channel.NS_SAY)
        return
    end

    local targetPos = npcObj:getPos()
    local targetX   = targetPos.x
    local targetZ   = targetPos.z
    local playerPos = player:getPos()
    local distance  = player:checkDistance(targetX, playerPos.y, targetZ)

    -- Angle between points
    -- NOTE: This is mapped to 0-255
    local angle = player:getWorldAngle(targetX, playerPos.y, targetZ)

    -- Map angle from 0-255 to 0-7 for the messageSpecial arg, with a small offset for cardinal direction
    local offset = 255 / 8
    local direction = math.floor(((7 - 0) / (255 - 0)) * ((angle + offset) - 0))

    local directionTable = {
        [0] = "east",
        [1] = "southeast",
        [2] = "south",
        [3] = "southwest",
        [4] = "west",
        [5] = "northwest",
        [6] = "north",
        [7] = "northeast",
    }
    local messageText = "You sense the something is %s in the %s direction!"
    local directionText = directionTable[direction]
    if directionText == nil then
        directionText = "unknown"
    end

    local distanceText = "unknown"
    if distance > 200 then
        distanceText = "distant"
    elseif distance > 100 then
        distanceText = "far"
    elseif distance > 50 then
        distanceText = "close"
    elseif distance > 25 then
        distanceText = "very close"
    else
        distanceText = "right next to you"
    end

    player:printToPlayer(
        string.format(
            messageText,
            distanceText,
            directionText
        ),
        xi.msg.channel.NS_SAY
    )
end

return commandObj
