﻿/************************************************************************
* setHomePointAt
* 
* Adds a new method to lua_baseentity (player:setHomePointAt)
* Specify an exact location for Home Point (Not just the current position)
 ************************************************************************/

#include "map/utils/moduleutils.h"

#include "map/lua/lua_baseentity.h"
#include "map/packets/char_emotion.h"

class SetHomePointAtModule : public CPPModule
{
    void OnInit() override
    {
        TracyZoneScoped;

        lua["CBaseEntity"]["setHomePointAt"] = [this](CLuaBaseEntity* PLuaBaseEntity, float x, float y, float z, uint8 r, uint8 zoneID) -> void {
            TracyZoneScoped;

            CBaseEntity* PEntity = PLuaBaseEntity->GetBaseEntity();

            auto* PChar = static_cast<CCharEntity*>(PEntity);

            position_t location;
            location.x = x;
            location.y = y;
            location.z = z;
            location.rotation = r;

            PChar->profile.home_point.p           = location;
            PChar->profile.home_point.destination = zoneID;

            const char* fmtQuery = "UPDATE chars \
                            SET home_zone = %u, home_rot = %u, home_x = %.3f, home_y = %.3f, home_z = %.3f \
                            WHERE charid = %u;";

            sql->Query(fmtQuery, PChar->profile.home_point.destination, PChar->profile.home_point.p.rotation, PChar->profile.home_point.p.x,
                       PChar->profile.home_point.p.y, PChar->profile.home_point.p.z, PChar->id);
        };
    }
};

REGISTER_CPP_MODULE(SetHomePointAtModule);
