/************************************************************************
* Item Util
*************************************************************************
* Lua item util functions
************************************************************************/
#include "map/utils/moduleutils.h"

#include "common/lua.h"
#include "common/sql.h"
#include "map/items/item.h"
#include "map/items/item_equipment.h"
#include "map/items/item_weapon.h"
#include "map/entities/battleentity.h"

class ItemUtilModule : public CPPModule
{
    void OnInit() override
    {
        TracyZoneScoped;

        /************************************************************************
        * Item Sell Price                                                       *
        ************************************************************************/
        lua["CItem"]["setBasePrice"] = [this](CLuaItem* PLuaItem, uint32 price) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();
            item->setBasePrice(price);
        };

        /************************************************************************
        * Item Flags                                                            *
        ************************************************************************/
        lua["CItem"]["getFlags"] = [this](CLuaItem* PLuaItem) -> uint16
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();
            return item->getFlag();
        };

        lua["CItem"]["setFlags"] = [this](CLuaItem* PLuaItem, uint32 flags) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();
            item->setFlag(flags);
        };

        /************************************************************************
        * Item Stack Size                                                       *
        ************************************************************************/
        lua["CItem"]["getStackSize"] = [this](CLuaItem* PLuaItem) -> uint32
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();
            return item->getStackSize();
        };

        lua["CItem"]["setStackSize"] = [this](CLuaItem* PLuaItem, uint32 stackSize) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();
            item->setStackSize(stackSize);
        };

        /************************************************************************
        * Equipment Mods                                                        *
        ************************************************************************/
        lua["CItem"]["getMods"] = [this](CLuaItem* PLuaItem) -> sol::table
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();
            auto mods = lua.create_table();

            if (!item->isType(ITEM_TYPE::ITEM_EQUIPMENT))
            {
                return mods;
            }

            auto query = "SELECT modId, value FROM item_mods WHERE itemId = %u;";

            if (sql->Query(query, item->getID()) == SQL_ERROR)
            {
                return mods;
            }

            while (sql->NextRow() == SQL_SUCCESS)
            {
                auto row     = lua.create_table();
                row.add(sql->GetUIntData(0), sql->GetIntData(1));
                mods.add(row);
            }

            return mods;
        };

        /************************************************************************
        * Equipment Level                                                       *
        ************************************************************************/
        lua["CItem"]["getLevel"] = [this](CLuaItem* PLuaItem) -> uint16
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_EQUIPMENT))
            {
                auto equip = dynamic_cast<CItemEquipment*>(item);
                return equip->getReqLvl();
            }
            {
                return 0;
            }
        };

        lua["CItem"]["setLevel"] = [this](CLuaItem* PLuaItem, uint16 level) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_EQUIPMENT))
            {
                auto equip = dynamic_cast<CItemEquipment*>(item);
                equip->setReqLvl(level);
            }
        };

        /************************************************************************
        * Equipment iLvl                                                        *
        ************************************************************************/
        lua["CItem"]["getIlvl"] = [this](CLuaItem* PLuaItem) -> uint16
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_EQUIPMENT))
            {
                auto equip = dynamic_cast<CItemEquipment*>(item);
                return equip->getILvl();
            }
            {
                return 0;
            }
        };

        lua["CItem"]["setIlvl"] = [this](CLuaItem* PLuaItem, uint16 ilvl) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_EQUIPMENT))
            {
                auto equip = dynamic_cast<CItemEquipment*>(item);
                equip->setILvl(ilvl);
            }
        };

        /************************************************************************
        * Equipment Jobs                                                        *
        ************************************************************************/
        lua["CItem"]["getJobs"] = [this](CLuaItem* PLuaItem) -> uint32
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_EQUIPMENT))
            {
                auto equip = dynamic_cast<CItemEquipment*>(item);
                return equip->getJobs();
            }
            {
                return 0;
            }
        };

        lua["CItem"]["setJobs"] = [this](CLuaItem* PLuaItem, uint32 jobs) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_EQUIPMENT))
            {
                auto equip = dynamic_cast<CItemEquipment*>(item);
                equip->setJobs(jobs);
            }
        };

        /************************************************************************
        * Equipment Model ID                                                    *
        ************************************************************************/
        lua["CItem"]["getModelID"] = [this](CLuaItem* PLuaItem) -> uint16
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_EQUIPMENT))
            {
                auto equip = dynamic_cast<CItemEquipment*>(item);
                return equip->getModelId();
            }
            else
            {
                return 0;
            }
        };

        lua["CItem"]["setModelID"] = [this](CLuaItem* PLuaItem, uint16 modelID) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_EQUIPMENT))
            {
                auto equip = dynamic_cast<CItemEquipment*>(item);
                equip->setModelId(modelID);
            }
        };

        /************************************************************************
        * Shield Size                                                           *
        ************************************************************************/
        lua["CItem"]["getShieldSize"] = [this](CLuaItem* PLuaItem) -> uint8
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_EQUIPMENT))
            {
                auto equip = dynamic_cast<CItemEquipment*>(item);
                return equip->getShieldSize();
            }
            else
            {
                return 0;
            }
        };

        lua["CItem"]["setShieldSize"] = [this](CLuaItem* PLuaItem, uint8 shieldSize) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_EQUIPMENT))
            {
                auto equip = dynamic_cast<CItemEquipment*>(item);
                equip->setShieldSize(shieldSize);
            }
        };

        /************************************************************************
        * Equipment Slot                                                        *
        ************************************************************************/
        lua["CItem"]["getSlot"] = [this](CLuaItem* PLuaItem) -> uint16
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_EQUIPMENT))
            {
                auto equip = dynamic_cast<CItemEquipment*>(item);
                return equip->getEquipSlotId();
            }
            else
            {
                return 0;
            }
        };

        lua["CItem"]["setSlot"] = [this](CLuaItem* PLuaItem, uint16 slot) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_EQUIPMENT))
            {
                auto equip = dynamic_cast<CItemEquipment*>(item);
                equip->setEquipSlotId(slot);
            }
        };

        /************************************************************************
        * Weapon Skill Type                                                     *
        ************************************************************************/
        lua["CItem"]["getSkillType"] = [this](CLuaItem* PLuaItem) -> uint8
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                return weapon->getSkillType();
            }
            else
            {
                return 0;
            }
        };

        lua["CItem"]["setSkillType"] = [this](CLuaItem* PLuaItem, uint8 skillType) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                weapon->setSkillType(skillType);
            }
        };

        /************************************************************************
        * Weapon Sub Skill Type                                                 *
        ************************************************************************/
        lua["CItem"]["getSubSkillType"] = [this](CLuaItem* PLuaItem) -> uint8
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                return weapon->getSubSkillType();
            }
            else
            {
                return 0;
            }
        };

        lua["CItem"]["setSubSkillType"] = [this](CLuaItem* PLuaItem, uint8 subSkillType) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                weapon->setSubSkillType(subSkillType);
            }
        };

        /************************************************************************
        * Weapon iLvl Skill                                                     *
        ************************************************************************/
        lua["CItem"]["getIlvlSkill"] = [this](CLuaItem* PLuaItem) -> uint16
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                return weapon->getILvlSkill();
            }
            else
            {
                return 0;
            }
        };

        lua["CItem"]["setILvlSkill"] = [this](CLuaItem* PLuaItem, uint16 skillLevel) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                weapon->setILvlSkill(skillLevel);
            }
        };

        /************************************************************************
        * Weapon iLvl Parry                                                     *
        ************************************************************************/
        lua["CItem"]["getIlvlParry"] = [this](CLuaItem* PLuaItem) -> uint16
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                return weapon->getILvlParry();
            }
            else
            {
                return 0;
            }
        };

        lua["CItem"]["setILvlParry"] = [this](CLuaItem* PLuaItem, uint16 skillLevel) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                weapon->setILvlParry(skillLevel);
            }
        };

        /************************************************************************
        * Weapon iLvl Macc                                                      *
        ************************************************************************/
        lua["CItem"]["getIlvlMacc"] = [this](CLuaItem* PLuaItem) -> uint16
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                return weapon->getILvlMacc();
            }
            else
            {
                return 0;
            }
        };

        lua["CItem"]["setILvlMacc"] = [this](CLuaItem* PLuaItem, uint16 skillLevel) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                weapon->setILvlMacc(skillLevel);
            }
        };

        /************************************************************************
        * Weapon Delay                                                          *
        ************************************************************************/
        lua["CItem"]["getDelay"] = [this](CLuaItem* PLuaItem) -> int16
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                return weapon->getDelay();
            }
            else
            {
                return 0;
            }
        };

        lua["CItem"]["setDelay"] = [this](CLuaItem* PLuaItem, int16 delay) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                weapon->setDelay(delay);
            }
        };

        /************************************************************************
        * Weapon Base Delay                                                     *
        ************************************************************************/
        lua["CItem"]["getBaseDelay"] = [this](CLuaItem* PLuaItem) -> int16
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                return weapon->getBaseDelay();
            }
            else
            {
                return 0;
            }
        };

        lua["CItem"]["setBaseDelay"] = [this](CLuaItem* PLuaItem, int16 baseDelay) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                weapon->setBaseDelay(baseDelay);
            }
        };

        /************************************************************************
        * Weapon Damage                                                         *
        ************************************************************************/
        lua["CItem"]["getDamage"] = [this](CLuaItem* PLuaItem) -> uint16
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                return weapon->getDamage();
            }
            else
            {
                return 0;
            }
        };

        lua["CItem"]["setDamage"] = [this](CLuaItem* PLuaItem, uint16 damage) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                weapon->setDamage(damage);
            }
        };

        /************************************************************************
        * Weapon Damage Type                                                    *
        ************************************************************************/
        lua["CItem"]["getDamageType"] = [this](CLuaItem* PLuaItem) -> uint16
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon  = dynamic_cast<CItemWeapon*>(item);
                auto dmgType = static_cast<uint16>(weapon->getDmgType());
                return dmgType;
            }
            else
            {
                return 0;
            }
        };

        lua["CItem"]["setDamageType"] = [this](CLuaItem* PLuaItem, uint16 damageType) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon  = dynamic_cast<CItemWeapon*>(item);
                auto newType = static_cast<DAMAGE_TYPE>(damageType);
                weapon->setDmgType(newType);
            }
        };

        /************************************************************************
        * Weapon Additional Effect                                              *
        ************************************************************************/
        lua["CItem"]["getAdditionalEffect"] = [this](CLuaItem* PLuaItem) -> uint8
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                return weapon->getAdditionalEffect();
            }
            else
            {
                return 0;
            }
        };

        lua["CItem"]["setAdditionalEffect"] = [this](CLuaItem* PLuaItem, uint8 additionalEffect) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                weapon->setAdditionalEffect(additionalEffect);
            }
        };

        /************************************************************************
        * Weapon Additional Effect                                              *
        ************************************************************************/
        lua["CItem"]["getHitCount"] = [this](CLuaItem* PLuaItem) -> uint8
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                return weapon->getHitCount();
            }
            else
            {
                return 0;
            }
        };

        lua["CItem"]["setHitCount"] = [this](CLuaItem* PLuaItem, uint8 hitCount) -> void
        {
            TracyZoneScoped;

            auto item = PLuaItem->GetItem();

            if (item->isType(ITEM_TYPE::ITEM_WEAPON))
            {
                auto weapon = dynamic_cast<CItemWeapon*>(item);
                weapon->setMaxHit(hitCount);
            }
        };
    }
};

REGISTER_CPP_MODULE(ItemUtilModule);
