﻿/************************************************************************
* Fishing Fatigue System
************************************************************************/
#include "map/utils/moduleutils.h"

#include "map/packets/chat_message.h"
#include "map/utils/charutils.h"
#include "map/lua/lua_baseentity.h"
#include "message.h"
#include "packets/message_basic.h"

extern uint8                                                                             PacketSize[512];
extern std::function<void(map_session_data_t* const, CCharEntity* const, CBasicPacket&)> PacketParser[512];

class FishingFatigueModule : public CPPModule
{
    std::string MSG_EMINENCE_RECORDS = "Your character type cannot undertake Records of Eminence.";

    std::string CHAR_TYPE   = "CHAR_TYPE"; // CharVar for Crystal Warrior status
    std::string CAUGHT      = "[FISHING]CAUGHT";

    uint8       QUEST_LOG_JEUNO = 3;
    uint8       QUEST_LOG_OTHER = 4;
    uint8       QUEST_SUBJOB_1  = 10;  // The Old Lady
    uint8       QUEST_SUBJOB_2  = 24;  // Elder Memories
    uint8       QUEST_GENKAI_3  = 130; // Whence the Wind Blows
    uint16      FISHING_LOWER   = 20;  // Lower limit for fishing
    uint16      FISHING_UPPER   = 300; // Upper limit for fishing

    bool isCrystalWarrior(CCharEntity* PChar)
    {
        uint16 charType = charutils::GetCharVar(PChar, CHAR_TYPE);
        return charType == 1 || charType == 2;
    }

    bool isWingsWarrior(CCharEntity* PChar)
    {
        return charutils::GetCharVar(PChar, CHAR_TYPE) == 3;
    }

    uint16 getCaughtLimit(CCharEntity* PChar)
    {
        if (isWingsWarrior(PChar))
        {
            bool sj1 = (PChar->m_questLog[QUEST_LOG_OTHER].complete[QUEST_SUBJOB_1 / 8] & (1 << (QUEST_SUBJOB_1 % 8))) != 0;
            bool sj2 = (PChar->m_questLog[QUEST_LOG_OTHER].complete[QUEST_SUBJOB_2 / 8] & (1 << (QUEST_SUBJOB_2 % 8))) != 0;

            return (sj1 || sj2) ? FISHING_UPPER : FISHING_LOWER;
        }
        else
        {
            bool g3 = (PChar->m_questLog[QUEST_LOG_JEUNO].complete[QUEST_GENKAI_3 / 8] & (1 << (QUEST_GENKAI_3 % 8))) != 0;

            return g3 ? FISHING_UPPER : FISHING_LOWER;
        }
    }

    void OnInit() override
    {
        TracyZoneScoped;
        /************************************************************************
        *                        PacketParser methods
        ************************************************************************/
        {
            auto playerAction        = PacketParser[0x01A];
            auto playerActionFatigue = [this, playerAction](map_session_data_t* const PSession, CCharEntity* const PChar, CBasicPacket data) -> void
            {
                TracyZoneScoped;

                uint8  action = data.ref<uint8>(0x0A);

                playerAction(PSession, PChar, data);
                if (action == 0x0E && ! isCrystalWarrior(PChar))
                {
                    uint16 caught = charutils::GetCharVar(PChar, CAUGHT);
                    uint16 limit  = getCaughtLimit(PChar) * (1.0f + PChar->getMod((Mod)2004) / 100.0f);

                    if (caught >= limit)
                    {
                        if (PChar->GetLocalVar("FishingFatigueMessage") == 0)
                        {
                            PChar->pushPacket(new CChatMessagePacket(PChar, MESSAGE_SYSTEM_3, "You have reached your daily fishing limit. "));
                            PChar->SetLocalVar("FishingFatigueMessage", 1);
                        }

                        PChar->lastCastTime += 600; // ensure first FISHACTION_CHECK auto fails and they catch nothing
                    }
                }
            };

            PacketParser[0x01A] = playerActionFatigue;
        }
    }
};

REGISTER_CPP_MODULE(FishingFatigueModule);

