# CatsEyeXI

## Basic Utilities
Loxley has created some additional utilities for everyone to use in their content. These tools are designed to speed up development time, provide a consistent experience for players, and leave our files looking as clean as possible.

### Formatted messages to player
Two extensions to the Base Entity allow easy formatting and printing of text.
```lua
-- NS_SAY
player:fmt("Your message here including variables {}, numbers {} or tables {}", name, 123, tbl)

-- SYSTEM_3
player:sys("{}'s skill rises 0.{} points.", player:getName(), amount)
```

### Debugging info or evals straight to your log
The `!get` command prints formatted lua evaluations including tables.
```lua
!get target:hasImmunity(xi.sleep.LIGHT_SLEEP)
!get xi.actions.spells.blue.sheep_song
```

### Moving and traveling to Dynamic Entities
Similar to the `!bringnpc` and `!gotoid` commands for standard entities, these commands allow you to easily move or move to Dynamic Entities. The names are case sensitive.
```lua
-- DE_Mob Name
!degoto Mob_Name

-- DE_Another Mob
!dehere Another_Mob
```

### Dynamic Entity look util
Using the lookTable function, we can easily create the hex string required for an NPC's (or humanoid mob's) appearance. Model IDs can be found in the `item_equipment` table, or simply use any of the pre-defined options from the `cexi.model` list.
```lua
look = cexi.util.look({
    race = xi.race.HUME_M,
    face = cexi.face.B4,
    head = cexi.model.RED_MAGE_RELIC,
    body = cexi.model.DALMATICA,
    hand = cexi.model.CRIMSON_SCALE_MAIL,
    legs = cexi.model.BLACK_MAGE_ARTIFACT,
    feet = cexi.model.CRIMSON_SCALE_MAIL,
    main = 270, -- Iron Sword
    offh = 25,  -- Kite Shield
}),
```

### Live reloadable Dynamic Entities
Entities defined in this way can be updated live, without the need for a server restart. The functions will be immediately reloaded once you save the lua file containing them. Additionally, some parameters such as position and rotation will be updated, provided the name of the entity does not change (As this is used to perform the lookup and apply the adjustments).
```lua
cexi.util.liveReload(m, {
    ["Oldton_Movalpolos"] =
    {
        {
            name      = "Goblin #1",
            objtype   = xi.objType.NPC,
            look      = 701,
            x         = -137.264,
            y         = 7.823,
            z         = 123.875,
            rotation  = 107,
            onTrigger = OnTrigger,
            onTrade   = OnTrade,
        },
        {
            name      = "Goblin #2",
            objtype   = xi.objType.NPC,
            look      = 702,
            x         = -137.264,
            y         = 7.823,
            z         = 123.875,
            rotation  = 107,
            onTrigger = onTrigger,
            onTrade   = onTrade,
        },
    },
})

```

### Simple Shop and Simple Menu
This utility provides convenient paginated menus straight from lua tables. Next/Prev page options will be added automatically once the list expands beyond 4 items.
```lua
local areas =
{
    { "Castle Oztroja", { 752.631, -32.000,  -40.035, 129, 119 } }, -- !pos 752.631 -32.000  -40.035 119
    { "Beadeaux",       { 578.786,  25.000, -376.731, 126, 109 } }, -- !pos 578.786 25.000 -376.731 109
    { "Davoi",          { -239.556, -7.764, -591.281, 187, 104 } }, -- !pos -239.556 -7.764 -591.281 104
}

cexi.util.simpleMenu(player, npc, areas, confirmFunction, "Choose a location:")
-- The confirm function will receive the entire row, allowing the selected position or any other data on that row to be retrieved
-- eg. player:setPos(unpack(area[2]))
```

Similar to `simpleMenu`, the `simpleShop` utility takes a table and forwards it to a function. This menu provides pricing information in the listing (Using the 3rd parameter). Additional parameters can be added as meta information about the selection, for example providing context dialog or an unlock instead of an item.
```lua
local rewards =
{
    { "M. Carp Creel x12", { { 5810, 12 } },  40 },
    { "Titanium Ore",                  4020,  60 },
    { "Fable Thread",                  9455,  60 },
    { "Gob. Commendation",             4035,  80 },
    { "Eltoro Leather",                1767, 200 },
    { "Viridian Urushi",               1763, 200 },
}

cexi.util.simpleShop(player, npc, rewards, confirmPurchase, fmt("Select an item ({} points):", balance))
-- The confirm function will receive the entire row, in this case the item name, id and cost
-- eg.
-- if npcUtil.giveItem(player, reward[2]) then
--     player:incrementCharVar(points, -reward[3])
-- end
```

## Friend Referral System
https://github.com/CatsAndBoats/modules/tree/main/documentation/friend_referral_system.md

## Regex for BG Wiki
https://github.com/CatsAndBoats/modules/tree/main/documentation/wiki_regex.md

## Quest System Documentation
https://github.com/CatsAndBoats/modules/tree/main/lua/additive_overrides/quests
