import subprocess
import os

jsonFilepath = 'json'
exeFilepath = 'bin'
romFilepath = 'rom'

dats = {
    # .json filename | .exe name | jp DAT | en DAT
    'Items_1': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\0\\4.DAT', 'enROM': 'ROM\\118\\106.DAT'},
    'Consumable_Items': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\0\\5.DAT', 'enROM': 'ROM\\118\\107.DAT'},
    'Puppet_Items': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\0\\8.DAT', 'enROM': 'ROM\\118\\110.DAT'},
    'Items_2': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\301\\114.DAT', 'enROM': 'ROM\\301\\115.DAT'},
    'Armor_1': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\0\\7.DAT', 'enROM': 'ROM\\118\\109.DAT'},
    'Weapons': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\0\\6.DAT', 'enROM': 'ROM\\118\\108.DAT'},
    'Armor_2': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\286\\72.DAT', 'enROM': 'ROM\\286\\73.DAT'},
    'Moblin_Maze_Mongers': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\217\\20.DAT', 'enROM': 'ROM\\217\\21.DAT'},
    'Monstrosity_1': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\288\\79.DAT', 'enROM': 'ROM\\288\\80.DAT'},
    'Records_of_Eminence_Objectives': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\307\\15.DAT', 'enROM': 'ROM\\307\\16.DAT'},
    'Items_3': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\314\\89.DAT', 'enROM': 'ROM\\314\\89.DAT'},
    'Monstrosity_2': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\288\\66.DAT', 'enROM': 'ROM\\288\\67.DAT'},
    'Records_of_Eminence_Categories': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\307\\23.DAT', 'enROM': 'ROM\\307\\24.DAT'},
    'Items_4': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\320\\26.DAT', 'enROM': 'ROM\\320\\26.DAT'},
    'Items_5': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\332\\47.DAT', 'enROM': 'ROM\\332\\49.DAT'},
    'Items_6': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\332\\46.DAT', 'enROM': 'ROM\\332\\48.DAT'},
    'Gil': {'exeFile': 'json2item.exe', 'jpROM': 'ROM\\0\\9.DAT', 'enROM': 'ROM\\174\\48.DAT'},
    'Job_Names_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\165\\86.DAT'},
    'Job_Names_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\165\\86.DAT'},
    'Help_Desk_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\165\\71.DAT'},
    'Help_Desk_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\165\\72.DAT'},
    'Search_Description_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\165\\74.DAT'},
    'Search_Description_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\165\\75.DAT'},
    'Server_Names_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\333\\33.DAT'},
    'Server_Names_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\333\\34.DAT'},
    'Heading_Names_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\165\\67.DAT'},
    'Heading_Names_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\165\\81.DAT'},
    'POL_Messages': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\165\\70.DAT'},
    'Equipment_Slot_Names_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\175\\32.DAT'},
    'Equipment_Slot_Names_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\175\\33.DAT'},
    'Blue_Mage_Spell_Help_Text_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\166\\115.DAT'},
    'Blue_Mage_Spell_Help_Text_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\166\\116.DAT'},
    'Augment_Attributes_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\220\\57.DAT'},
    'Augment_Attributes_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\220\\58.DAT'},
    'Menu_Merit_Points_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\169\\74.DAT'},
    'Menu_Merit_Points_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\169\\75.DAT'},
    'Menu_Job_Points_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\314\\61.DAT'},
    'Menu_Job_Points_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\314\\62.DAT'},
    'Menu_Job_Point_Gifts_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\324\\58.DAT'},
    'Menu_Job_Point_Gifts_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\324\\59.DAT'},
    'Soulplate_Attributes_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\187\\67.DAT'},
    'Soulplate_Attributes_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\187\\71.DAT'},
    'Trust_Messages_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\311\\73.DAT'},
    'Trust_Messages_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\311\\74.DAT'},
    'Emote_Help_Text_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\327\\123.DAT'},
    'Emote_Help_Text_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\327\\124.DAT'},
    'Chat_Window_Command_Help_Text_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\173\\88.DAT'},
    'Chat_Window_Command_Help_Text_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\173\\89.DAT'},
    'Monster_Family_Names_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\188\\37.DAT'},
    'Monster_Family_Names_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\188\\38.DAT'},
    'Moblin_Maze_Mongers_Rune_Help_Text_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\219\\85.DAT'},
    'Moblin_Maze_Mongers_Rune_Help_Text_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\219\\86.DAT'},
    'Titles_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\180\\77.DAT'},
    'Titles_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\180\\78.DAT'},
    'Key_Items_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\175\\34.DAT'},
    'Key_Items_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\175\\35.DAT'},
    'Status_Names_with_Adjectives_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\180\\101.DAT'},
    'Status_Names_with_Adjectives_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\180\\102.DAT'},
    'Spell_Names_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\181\\69.DAT'},
    'Spell_Names_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\181\\73.DAT'},
    'Spell_Help_Text_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\181\\71.DAT'},
    'Spell_Help_Text_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\181\\75.DAT'},
    'Ability_Names_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\181\\68.DAT'},
    'Ability_Names_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\181\\72.DAT'},
    'Ability_Help_Text_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\181\\70.DAT'},
    'Ability_Help_Text_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\181\\74.DAT'},
    'Mount_Names_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\351\\82.DAT'},
    'Mount_Names_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\351\\84.DAT'},
    'Mount_Help_Text_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\351\\83.DAT'},
    'Mount_Help_Text_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\351\\85.DAT'},
    'Quests_SandOria_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\176\\46.DAT'},
    'Quests_SandOria_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\176\\60.DAT'},
    'Quests_Bastok_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\176\\47.DAT'},
    'Quests_Bastok_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\176\\61.DAT'},
    'Quests_Windurst_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\176\\48.DAT'},
    'Quests_Windurst_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\176\\62.DAT'},
    'Quests_Jeuno_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\176\\49.DAT'},
    'Quests_Jeuno_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\176\\63.DAT'},
    'Quests_Other_Areas_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\176\\50.DAT'},
    'Quests_Other_Areas_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\176\\64.DAT'},
    'Quests_Treasures_of_Aht_Urhgan_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\176\\52.DAT'},
    'Quests_Treasures_of_Aht_Urhgan_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\176\\66.DAT'},
    'Quests_Wings_of_the_Goddess_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\196\\3.DAT'},
    'Quests_Wings_of_the_Goddess_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\196\\6.DAT'},
    'Quests_Abyssea_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\242\\63.DAT'},
    'Quests_Abyssea_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\242\\64.DAT'},
    'Quests_Assault_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\176\\58.DAT'},
    'Quests_Assault_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\176\\72.DAT'},
    'Quests_Campaign_Ops_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\196\\5.DAT'},
    'Quests_Campaign_Ops_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\196\\8.DAT'},
    'Quests_Seekers_of_Adoulin_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\293\\67.DAT'},
    'Quests_Seekers_of_Adoulin_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\293\\70.DAT'},
    'Quests_Coalition_Assignments_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\293\\68.DAT'},
    'Quests_Coalition_Assignments_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\293\\71.DAT'},
    'Missions_SandOria_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\176\\53.DAT'},
    'Missions_SandOria_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\176\\67.DAT'},
    'Missions_Bastok_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\176\\54.DAT'},
    'Missions_Bastok_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\176\\68.DAT'},
    'Missions_Windurst_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\176\\55.DAT'},
    'Missions_Windurst_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\176\\69.DAT'},
    'Missions_Rise_of_the_Zilart_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\176\\56.DAT'},
    'Missions_Rise_of_the_Zilart_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\176\\70.DAT'},
    'Missions_Chains_of_Promathia_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\176\\57.DAT'},
    'Missions_Chains_of_Promathia_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\176\\71.DAT'},
    'Missions_Treasures_of_Aht_Urhgan_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\176\\59.DAT'},
    'Missions_Treasures_of_Aht_Urhgan_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\176\\73.DAT'},
    'Missions_Wings_of_the_Goddess_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\196\\4.DAT'},
    'Missions_Wings_of_the_Goddess_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\196\\7.DAT'},
    'Missions_A_Crystalline_Prophecy_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\222\\17.DAT'},
    'Missions_A_Crystalline_Prophecy_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\222\\18.DAT'},
    'Missions_A_Moogle_Kupo_dEtat_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\223\\10.DAT'},
    'Missions_A_Moogle_Kupo_dEtat_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\223\\12.DAT'},
    'Missions_A_Shantotto_Ascension_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\223\\11.DAT'},
    'Missions_A_Shantotto_Ascension_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\223\\13.DAT'},
    'Missions_Seekers_of_Adoulin_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\293\\66.DAT'},
    'Missions_Seekers_of_Adoulin_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\293\\69.DAT'},
    'Missions_Rhapsodies_of_Vanadiel_JP': {'exeFile': 'json2dmsg.exe', 'jpROM': 'ROM\\333\\3.DAT'},
    'Missions_Rhapsodies_of_Vanadiel_EN': {'exeFile': 'json2dmsg.exe', 'enROM': 'ROM\\333\\4.DAT'},
    'Spell_Ability_Metadata': {'exeFile': 'json2mgc.exe', 'jpROM': 'ROM\\118\\114.DAT', 'enROM': 'ROM\\118\\114.DAT'},
    'Blue_Mage_Spell_Help': {'exeFile': 'json2mgc.exe', 'jpROM': 'ROM\\166\\115.DAT', 'enROM': 'ROM\\166\\116.DAT'} #add comma once below is active
    #'UI','exeFN', 'enROM': 'ROM\\91\\15.DAT', 'enROM': 'ROM\\119\\51.DAT'},
    #'Title_Screen','exeFN', 'enROM': 'ROM\\91\\16.DAT', 'enROM': 'ROM\\119\\50.DAT'},
    #'Skill_Names','exeFN', 'enROM': 'ROM\\27\\65.DAT', 'enROM': 'ROM\\27\\66.DAT'},
    #'Modifier_Flags','exeFN', 'enROM': 'ROM\\27\\67.DAT', 'enROM': 'ROM\\27\\68.DAT'},
    #'Emotes','exeFN', 'enROM': 'ROM\\27\\69.DAT', 'enROM': 'ROM\\27\\70.DAT'},
    #'Ability_Messages','exeFN', 'enROM': 'ROM\\27\\71.DAT', 'enROM': 'ROM\\27\\72.DAT'},
    #'Status_Names','exeFN', 'enROM': 'ROM\\27\\73.DAT', 'enROM': 'ROM\\27\\74.DAT'},
    #'System_Messages','exeFN', 'enROM': 'ROM\\27\\75.DAT', 'enROM': 'ROM\\27\\76.DAT'},
    #'Ability_Names_256','exeFN', 'enROM': 'ROM\\27\\79.DAT', 'enROM': 'ROM\\27\\80.DAT'},
    #'Unity_Messages','exeFN', 'enROM': 'ROM\\337\\67.DAT', 'enROM': 'ROM\\337\\68.DAT'},
    #'Zones_1','exeFN', 'enROM': 'ROM3\\1\\38.DAT', 'enROM': 'ROM3\\2\\10.DAT'},
    #'Zones_2','exeFN', 'enROM': 'ROM9\\5\\77.DAT', 'enROM': 'ROM9\\5\\101.DAT'},
    #'Zones_3','exeFN', 'enROM': 'ROM\\186\\103.DAT', 'enROM': 'ROM\\186\\97.DAT'},
    #'Zones_4','exeFN', 'enROM': 'ROM\\214\\63.DAT', 'enROM': 'ROM\\214\\64.DAT'}
}

def ensure_file_exists(filepath):
    """Ensure that a given file exists, creating directories or the file as necessary."""
    directory = os.path.dirname(filepath)
    if not os.path.isdir(directory):
        os.makedirs(directory)
    if not os.path.exists(filepath):
        open(filepath, 'w').close()

def process_file_with_exe(exe_filename, json_filename, *rom_files):
    """Run the subprocess command with given exe and ROM files."""
    try:
        subprocess.run([exe_filename, json_filename, *rom_files])
    except subprocess.CalledProcessError as e:
        print(f"Error processing {json_filename} with {exe_filename}. Error: {e}")

# Main logic
for filename in os.scandir(os.path.join('.', jsonFilepath)):
    if filename.is_file():
        pwd = os.getcwd()
        fileNameNoExt = os.path.splitext(os.path.basename(filename))[0]
        exeFilename = os.path.join(pwd, exeFilepath, dats[fileNameNoExt]['exeFile'])
        jsonFilename = os.path.join(pwd, jsonFilepath, f"{fileNameNoExt}.json")

        if fileNameNoExt in dats:
            rom_files = []
            print(f"Processing {fileNameNoExt}...")
            if 'jpROM' in dats[fileNameNoExt]:
                jpFilename = os.path.join(pwd, romFilepath, dats[fileNameNoExt]['jpROM'])
                ensure_file_exists(jpFilename)
                rom_files.append(jpFilename)

            if 'enROM' in dats[fileNameNoExt]:
                enFilename = os.path.join(pwd, romFilepath, dats[fileNameNoExt]['enROM'])
                ensure_file_exists(enFilename)
                rom_files.append(enFilename)

            if 'json2dmsg.exe' in exeFilename:
                process_file_with_exe(exeFilename, jsonFilename, *rom_files)
            elif 'json2item.exe' in exeFilename or 'json2mgc.exe' in exeFilename:
                process_file_with_exe(exeFilename, jsonFilename, *rom_files)
            else:
                print(f"'jpROM' and/or 'enROM' not found in dats[{fileNameNoExt}]")
        else:
            print(f"{fileNameNoExt} not found in dats")