<link href="assets/create/create.css" rel="stylesheet" />
<div id="create-begin" class="container">
<div class="row">
<div class="col-12">
<?php
	require_once('submission.php');
	require_once('functions.php');
	require_once("includes/migration.php");
?>

<?php

// Update charcount after character created
$charcount = getCharacterCount($users['id']);

if ($charcount == 'error')
{
	echo getPanel("warning","Warning","Could not get Characters.");
}

$max = 1;

if ($accounttype == '1') {
	$max = 2;
}

if ($accounttype == '2') {
	$migrationChars = WingsMigration::getWingsList($users['id']);
	$max = 5;

	if (!empty($migrationChars)) {
		$max = $max - sizeof($migrationChars);
	}
}

echo '<div id="current-table">';
echo 'Current Character Count: <span>'.$charcount.'</span><br/>';
echo 'Max Characters: <span>'.$max.'</span><br />';
if($charcount<$max){
	$remain=$max-$charcount;

	echo '(You currently have <span>'.$remain.'</span> slot/s available)<br />
	</div>
	<div class="alert alert-info" role="alert">
		<button class="btn btn-info" id="create-start">Create New Character</button>
		Note: Characters Cannot Be Deleted Until they are at least 7 days old
	</div>';

}
else {
	echo '</div>';
}

?>
</div> <!-- /.col12 -->
</div> <!-- /.row -->
</div> <!-- /#create-begin -->

<section id="create-container">

<ul class="nav nav-tabs" id="create-tabs" role="tablist">
	<span class="glyphicon glyphicon-menu-left"></span>
	<li id="tab-race" class="nav-item" role="presentation">
		<button class="nav-link active" data-bs-toggle="tab" data-bs-target="#select-race" type="button" role="tab" aria-controls="select-race" aria-selected="true">
			<span class="prog">&check;</span> Race & Gender
		</button>
	</li>
	<li id="tab-face" class="nav-item" role="presentation">
		<button class="nav-link" data-bs-toggle="tab" data-bs-target="#select-face" type="button" role="tab" aria-controls="select-face" aria-selected="false" tabindex="-1">
			<span class="prog">&check;</span> Appearance
		</button>
	</li>
	<li id="tab-size" class="nav-item" role="presentation">
		<button class="nav-link" data-bs-toggle="tab" data-bs-target="#select-size" type="button" role="tab" aria-controls="select-size" aria-selected="false" tabindex="-1">
			<span class="prog">&check;</span> Size
		</button>
	</li>
	<li id="tab-job" class="nav-item" role="presentation">
		<button class="nav-link" data-bs-toggle="tab" data-bs-target="#select-job" type="button" role="tab" aria-controls="select-job" aria-selected="false" tabindex="-1">
			<span class="prog">&check;</span> Starting Job
		</button>
	</li>
	<li id="tab-nation" class="nav-item" role="presentation">
		<button class="nav-link" data-bs-toggle="tab" data-bs-target="#select-nation" type="button" role="tab" aria-controls="select-job" aria-selected="false" tabindex="-1">
			<span class="prog">&check;</span> Starting Nation
		</button>
	</li>
	<li id="tab-finish" class="nav-item" role="presentation">
		<button class="nav-link" data-bs-toggle="tab" data-bs-target="#select-finish" type="button" role="tab" aria-controls="select-finish" aria-selected="false" tabindex="-1">
			<span class="prog">&check;</span> Finish
		</button>
	</li>
	<span class="glyphicon glyphicon-menu-right"></span>
</ul>

<div id="create-char" class="tab-content">
<form action="/index.php?p=create" method="post">

<section id="select-race" class="tab-pane fade show active" role="tabpanel" aria-labelledby="select-race">
<div class="container text-center">
<?php
	selectionHeader($stepMessage[0], $accounttype);
	selectionRace([ ["Hume Male", 1], ["Elvaan Male", 3], ["Tarutaru Male", 5], ["Galka Male", 8] ]);
	selectionRace([ ["Hume Female", 2], ["Elvaan Female", 4], ["Tarutaru Female", 6], ["Mithra Female", 7] ]);
?>
</div>
</section>

<section id="select-face" class="tab-pane fade" role="tabpanel" aria-labelledby="select-face">
<div class="container text-center">
<?php selectionHeader($stepMessage[1], $accounttype); ?>

<?php
	selectionFace([ ["1A",  0], ["2A",  2], ["3A",  4], ["4A",  6], ["1B",  1], ["2B",  3], ["3B",  5], ["4B",  7] ]);
	selectionFace([ ["5A",  8], ["6A", 10], ["7A", 12], ["8A", 14], ["5B",  9], ["6B", 11], ["7B", 13], ["8B", 15] ]);
?>
</div>
</section>

<section id="select-size" class="tab-pane fade" role="tabpanel" aria-labelledby="select-size">
<div class="container text-center">
	<?php selectionHeader($stepMessage[2], $accounttype); ?>
	<div class="row" id="select-size">
		<label class="col">
		<input type="radio" name="size" value="2" data-id="2" data-text="Large" />
		<img src="theme/v1/images/chars/large.png" class="rounded selectable" alt="Large" title="Large" data-id="2" height=250 width=250 />
		<br />Large
		</label>
		<label class="col">
		<input type="radio" name="size" value="1" data-id="1" data-text="Medium" />
		<img src="theme/v1/images/chars/medium.png" class="rounded selectable" alt="Medium" title="Medium" data-id="1" height=250 width=250 />
		<br />Medium
		</label>
		<label class="col">
		<input type="radio" name="size" value="0" data-id="0" data-text="Small" />
		<img src="theme/v1/images/chars/small.png" class="rounded selectable" alt="Small" title="Small" data-id="0" height=250 width=250 />
		<br />Small
		</label>
	</div>
</div>
</section>

<section id="select-job" class="tab-pane fade" role="tabpanel" aria-labelledby="select-job">
<div class="container text-center">
<?php
	selectionHeader($stepMessage[3], $accounttype);
	selectionJob([ ["Warrior",    1], ["Monk",     2], ["White Mage", 3] ]);
	selectionJob([ ["Black Mage", 4], ["Red Mage", 5], ["Thief",      6] ]);
?>
</div>
</section>

<section id="select-nation" class="tab-pane fade" role="tabpanel" aria-labelledby="select-nation">
<div class="container text-center">
<?php selectionHeader($stepMessage[4], $accounttype); ?>
<?php
if ($accounttype == '1') {
	selectionNationCW([ ["San d'Oria",    0], ["Bastok",     1], ["Windurst", 2] ]);
	selectionNationDesc([
		[
			"sandoria",
			"King Ranperre's Tomb",
			"San d'Oria",
			"Deep in Ronfaure Forest lies the final resting place of King Ranperre R d'Oraguille. The Crystal Warrior begins their journey, rising from the mysterious crypts below."
		],
		[
			"bastok",
			"Dangruf Wadi",
			"Bastok",
			"The hot springs of Dangruf Wadi serve as a welcome retreat from the rugged Gustaberg hills. The Crystal Warrior begins here, rising from long forgotten ruins where everything is not what it seems."
		],
		[
			"windurst",
			"Toraimarai Canal",
			"Windurst",
			"In the undergrowth of the Star Tree, the forbidden Animastery's once sealed doors creak open. The Crystal Warrior emerges, as something strange stirs and a new adventure begins."
		]
	]);

}
else {
	selectionNation([ ["San d'Oria",    0], ["Bastok",     1], ["Windurst", 2] ]);
}
?>
</div>
</section>
<section id="select-finish" class="tab-pane fade" role="tabpanel" aria-labelledby="select-finish">
<div class="container text-center">
<?php
	selectionHeader($stepMessage[5], $accounttype);
?>
<div class="row">
<div class="col-12">
	<div class="form-group" id="name-check">
		<input type="text" name="name" class="form-control" />
		<button type="button" class="btn btn-info">
			<span id="checking" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
			<span class="sr-only">Check Name</span>
		</button>
	</div>
	<div id="name-length"><span>&cross;</span> Your name must be 3-15 characters.</div>
	<div id="name-special"><span>&cross;</span> Your name cannot contain special characters or numbers.</div>
	<div id="name-available"><span>&check;</span> Your name is available.</div>
	<div id="name-unavailable"><span>&cross;</span> That name is not available.</div>
</div>
</div>
<div class="row" id="confirm-table">
<div class="col-12 center">
<img src="theme/v1/images/nations/3/flag.png" id="result-nation-flag" width=250 height=250 />
<img src="theme/v1/images/cw/crystal.png" id="result-face-img" width=250 height=250 />
<table id="final-table">
<tr id="confirm-race">
	<td class="confirm-title"><span class="prog">&check;</span> Race & Gender</td>
	<td id="result-race" class="char-result">-</td>
</tr>
<tr id="confirm-face">
	<td class="confirm-title"><span class="prog">&check;</span> Appearance</td>
	<td id="result-face" class="char-result">-</td>
</tr>
<tr id="confirm-size">
	<td class="confirm-title"><span class="prog">&check;</span> Size</td>
	<td id="result-size" class="char-result">-</td>
</tr>
<tr id="confirm-job">
	<td class="confirm-title"><span class="prog">&check;</span> Starting Job</td>
	<td class="char-result"><img id="result-job-img" src="theme/v1/images/jobicons/0.png" /> <span id="result-job">-</span></td>
</tr>
<tr id="confirm-nation">
	<td class="confirm-title"><span class="prog">&check;</span> Allegiance</td>
	<td class="char-result"><img id="result-nation-img" src="theme/v1/images/nations/3/flag.png" width=32 height=32 /> <span id="result-nation">-</span></td>
</tr>
</table>
</div>
</div>
<div id="final-confirm">Confirm Creation: Cannot be undone and you must wait 7 days to delete.</div>
<input type="submit" class="btn btn-info action-btn" role="button" id="create-submit" disabled="disabled" value="Create Character" />
</div>

</section> <!-- /# -->

</form>
</div> <!-- /#create-char -->
</section> <!-- /#create-container -->

<script type="text/javascript" src="https://code.jquery.com/jquery-3.6.0.js"></script>
<script type="text/javascript" src="assets/create/create.js"></script>
