<?php
require_once('submission.php');
require_once("includes/migration.php");
?>

<?php
    $disableWingsNewChars   = false;
    $disableWingsMigrations = false;
?>

<link href="assets/chars/chars.css" rel="stylesheet" />

<?php if ($accounttype == '2') { ?>
    <?php if ($account['validated'] == 0) { ?>
        <center><p>Before you begin playing, you'll need to <a href="/index.php?p=validate">validate</a> your account.</p></center>
    <?php } ?>
    <?php $migrationChars = WingsMigration::getWingsList($users['id']); ?>

    <?php if (!empty($migrationChars)) { ?>

    <div id="mig-info">
    <?= getPanel("info","Note","This does not represent the final state of your characters. You may continue playing on WingsXI until the process is complete."); ?>
    </div>

    <div class="container">
    <div class="row" id="extra-pad"><div class="col-xs-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4"><div class="card-group">

    <?php foreach($migrationChars as $char) { ?>
    <?php $nameAvailable = WingsMigration::nameAvailable($char['name']); ?>
    <div class="row">
        <div class="card mb-3 staff-card">
            <div class="row g-0">
                <div class="col-md-6">
                    <img src="theme/v1/images/chars/<?= $char['race']; ?>/<?= $char['face']; ?>.jpg" class="img-fluid rounded-start">
                </div>
                <div class="col-md-6">
                    <div class="card-body text-center">
                        <h5 class="card-title<?php if (!$nameAvailable) { echo ' taken'; } ?>"><strong><?= $char['name']; ?></strong></h5>
                        <?= $char['main_job_lv'].strtoupper($jobs[$char['main_job']]); ?>
                        <?php if (!empty($char['sjob'])) { echo '/'.$char['slvl'].strtoupper($jobs[$char['sjob']]); } ?>
                        <br />
                        <?= getZoneName($char['zone']); ?>
                        <br /><br />
                        <strong class="ready">(Ready)</strong>
                    </div>
                </div>
                <div class="row g-0">
                    <div class="col-md-12">
                        <?php if (!$disableWingsMigrations) { ?>
                            <form action="/index.php?p=chars" method="post">
                                <input type="hidden" name="charid" value="<?= $char['charid']; ?>" />
                                <?php if ($nameAvailable) { ?>
                                <input type="hidden" name="name" value="<?= $char['name']; ?>" />
                                <?php } else { ?>
                                <div id="name-taken">
                                    <div class="text-center p-3" id="taken">Your character name is taken.<br />Please enter a new name below:</div>
                                    <div class="form-group" id="name-check">
                                        <input type="text" name="name" class="form-control" />
                                        <button type="button" class="btn btn-info">
                                            <span id="checking" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                            <span class="sr-only">Check Name</span>
                                        </button>
                                    </div>
                                    <div class="text-center">
                                        <div id="name-length"><span>&cross;</span> Your name must be 3-15 characters.</div>
                                        <div id="name-special"><span>&cross;</span> Your name cannot contain special characters or numbers.</div>
                                        <div id="name-available"><span>&check;</span> Your name is available.</div>
                                        <div id="name-unavailable"><span>&cross;</span> That name is not available.</div>
                                    </div>
                                </div>
                                <?php } ?>
                                <div class="text-center p-2">
                                    <input type="submit" class="btn btn-outline-info<?php if (!$nameAvailable) { echo ' hidden'; } ?>" role="button" id="finish-migration" value="Finish Migration">
                                </div>
                            </form>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
    </div></div></div></div>
    <?php } ?>
<?php } ?>

<?php

$chars = getCharacterList($users['id']);

if ($accounttype == '2' && $disableWingsNewChars) {

}
elseif ($chars == 'error')
{
    echo getPanel("warning","Warning","Could not get Characters.");
}
else
{
    $max=1;

    if ($accounttype == '1') {
        $max = 2;
    }
    elseif ($accounttype == '2') {
        $max = 5;
    }

    if ($charcount < $max) {
        echo getPanel("success","Create","You are able to create more characters <a href=?p=create>Here</a>");
    }

    echo '<div class="row"><div class="col-xs-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4"><div class="card-group">';
    if ($chars != 'empty') {
        foreach($chars as $char) {
            $created = strtotime($char['timecreated']);
            $deletedate = strtotime("+7 day", $created);

            if (empty($_GET['delete']) || $accounttype == '2') {
            }
            elseif ($_GET['delete'] == $char['charid']) {
                if (empty($_GET['confirm'])) {
                    if ($deletedate>=time()) {
                        echo '<div class="alert alert-danger">
                                    <div class="panel-heading">
                                        <strong>Danger</strong> <br> You cannot delete this character yet.
                                    </div>
                            </div>';
                    }
                    else {
                        echo '<div class="alert alert-warning">
                                <div class="panel-heading">
                                    <strong>Warning</strong> <br> Confirm Delete cannot be undone!! <a href=?p=chars&delete='.$_GET['delete'].'&confirm=1>Confirm</a>
                                </div>
                            </div>';
                    }
                }
                else {
                    if ($deletedate>=time()) {
                        echo '<div class="alert alert-danger">
                                <div class="panel-heading">
                                    <strong>Danger</strong> <br> You cannot delete this character yet.
                                </div>
                            </div>';
                    }
                    else {
                        echo deleteCharacter($_GET['delete'],$users['id']);
                    }
                }
            }
            echo '
            <div class="row">
                <div class="card mb-3 staff-card">
                    <div class="row g-0">
                        <div class="col-md-6">
                            <img src="theme/v1/images/chars/'.$char['race'].'/'.$char['face'].'.jpg" class="img-fluid rounded-start">
                        </div>
                        <div class="col-md-6">
                            <div class="card-body text-center">
                                <a href="?p=characters&id='.$char['charid'].'"><h5 class="card-title">'.$char['charname'].'</h5></a>
                                '.$char['mlvl'].strtoupper($jobs[$char['mjob']]).(!empty($char['sjob']) ? '/'.$char['slvl'].strtoupper($jobs[$char['sjob']]) : '').'<br>
                                '.getZoneName($char['pos_zone']).'<br>
                            </div>
                            <div class="card-body text-center">';
          					if ($accounttype != '1'){
                                echo '<a href="?p=chars&unstuck='.($char['charid']).'">Unstuck</a><br>';
                            }

                                echo '<a href="?p=chars&forceoff='.($char['charid']).'">Force Offline</a><br>';
        						if ($accounttype != '2' && $deletedate<=time()){
        							echo '
                                <a href="?p=chars&delete='.($char['charid']).'">Delete</a>';
        						}
        						
                            echo '</div>
                        </div>
                    </div>
                </div>
            </div>
            ';
        }
    }
};

?>

</div>
</div>

<script type="text/javascript" src="https://code.jquery.com/jquery-3.6.0.js"></script>
<script type="text/javascript" src="assets/chars/chars.js"></script>
