<div class="container-fluid" id="content">
	<div class="row">
		<div class="card mb-3 about-card">
			<div class="row g-0">
				<div class="col-md-4">
					<img src="images/NewLogo.png" class="img-fluid start" alt="...">
					<img src="images/NewByakko.png" class="img-fluid start" alt="...">
				</div>
				<div class="col-md-8">
					<div class="card-body about-card" style="margin-left:1rem;">
						<div class="row p-3">
							<h2 class="card-title">About CatsEye XI</h2>
								<div class="container border border-success rounded p-3 about-card-body">
									<p class="card-text">CatsEye XI is a private Final Fantasy XI server that has quality of life improvements while still maintaining the 75 era feel that is beloved by many FFXI players.</p>
									<p class="card-text">Our vision is to create an experience where both new and returning players can enjoy all aspects of FFXI, without as much of the time sink that was required to do so in 75 era retail.
									In addition, we aim to create new exciting experiences with our custom content for those looking for a new twist on their favorite game!
									</p>
									<p>
									CatsEye XI runs on the <a href="https://github.com/LandSandBoat/server/">LandSandBoat</a> platform, which is religiously maintained and supported by a community of talented, enthusiastic fans; many of which are developers either by hobby or by trade.
									This open-source project receives dozens of contributions each month, which makes it one of the most retail-accurate FFXI emulataors available.
									</p>
									<p>
									Our developers maintain a close working relationship with the LSB team, and are one of the few servers that not only submits bug reports to LSB, but also attempts to fix them upstream as well.
									</p>
								</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="card mb-3 about-card">
		<h4 class="card-title">Quality of Life Improvements</h4>
			<div class="row g-0">
				<div class="col-md-4">
					<ul class="list-group">
						<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Trusts Enabled</li>
						<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Modern Job Abilities, Weapon Skills, & Spells</li>
						<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Increased Combat, Magic, and Crafting Skill Gain Rate</li>
						<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Fields/Grounds of Valor</li>
						<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Mounts Enabled</li>
						<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> All Maps Unlocked</li>
						<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> All Outposts Unlocked</li>
						<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Sprout Beret & Echad Ring Enabled</li>
						<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Global Linkshell with LS Events</li>
					</ul>
				</div>
				<div class="col-md-8">
					<div class="card-body about-card" style="margin-left:1rem;">
						<div class="container border border-success rounded p-3 about-card-body">
							<p>
							An example of how we incorporate quality of life changes while still maintaining the "75 era feel" is by starting all new players out with Outpost Warps and maps unlocked, but still require players to unlock the Home Point Crystal Network and Surival Guides.
							</p>
							<p>
							We want players to actually experience the content by traversing into new territories to complete quests/missions; unlocking the HPs and survival guides in the process. However, access to Outpost Warps and maps makes the game more accessible to find an EXP group, complete Missions, or experience other content while still having to put the work in to unlock the fastest travel methods.
							</p>
							<p>
							Several of our developers fondly remember the prime of the 75 era retail experience, but have since grown to a point in our lives where we just don't have the time to commit to that grind. As a result, our design philosophy is not to fundamentally change the "75 era feel", but to enhance it and make the game more accessible to all players.
							</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="card mb-3 about-card">
		<h4 class="card-title">Custom Content</h4>
			<div class="row g-0">
				<div class="col-md-8">
					<div class="container border border-success rounded p-3 about-card-body">
						<p>
						In addition to the quality of life changes that we make to the server, our developers are also hard at work making new custom content for you to experience!
						While maintaining a retail accurate feel is a high priority, we still believe that new content is what will keep our community engaged and thriving long-term. This also allows our developers to express some creative freedom in their work that everyone will benefit from.
						</p>
						<h5>Sky Augment System</h5>
						<p>Augment your sky abjuration gear with tatters by trading your uncursed equipment and the required tatter to the synergy furnaces.</p>
						<h5>AF+1 Augment System</h5>
						<p>Augment your your AF+1 gear by trading organs and your AF+1 equipment to Vision in Port Jeuno</p>
						<h5>Sky 2.0</h5>
						<p>Our developers have created custom fights for all Sky Gods in Escha Ru'Aun. They are some of the toughest fights in the game!</p>
						<h5>Custom Loot Pools</h5>
						<p>Because some of the original FFXI content is still under development, some loot pools on HNMs have been modified to drop rare items like salvage pieces!</p>
						<p>
							<a href="https://www.bg-wiki.com/ffxi/Category:CatsEyeXI" class="hyper-link"><strong>Read more about our custom content on our wiki!</strong></a>
						</p>
					</div>
				</div>
				<div class="col-md-4">
					<div class="card-body about-card" style="margin-left:1rem;">
						<ul class="list-group">
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Sky Augment System</li>
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> AF+1 Augment System</li>
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Domain Invasion</li>
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Sky 2.0</li>
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Zeni Notorious Monsters</li>
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Nyzul Isle</li>
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Custom HNM System</li>
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Custom Loot Pools</li>
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Login Campaign</li>
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Free Relic for Crafters</li>
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Mythic/Aeonic WS Quests</li>
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> RUN/GEO Unlockable with AF Quests</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="card mb-3 about-card">
		<h4 class="card-title">Our Staff</h4>
			<div class="row g-0">
				<div class="col-md-8">
					<div class="card-body about-card-group" style="padding-top: 0px !important; padding-left: 0px !imporant;">
						<div class="row">
							<div class="col-6 ps-0">
								<div class="card mb-3 staff-card">
									<div class="row g-0">
										<div class="col-md-6">
										<img src="images/carver.jpg"class="img-fluid rounded-start" alt="Carver">
										</div>
										<div class="col-md-6">
										<div class="card-body staff-card-body">
											<h5 class="card-title">Carver</h5>
											<p class="card-text">Server Owner<br>Admin/Developer<br>Jun 2021<br><img src="images/discord_ico.png" width=25 height=20><a href="#" class="card-link"> Carver#0744</a></p>
										</div>
										</div>
									</div>
								</div>
							</div>
							<div class="col-6 ps-0">
								<div class="card mb-3 staff-card">
									<div class="row g-0">
										<div class="col-md-6">
										<img src="images/hax.jpg"class="img-fluid rounded-start" alt="Hax">
										</div>
										<div class="col-md-6">
										<div class="card-body staff-card-body">
											<h5 class="card-title">Hax</h5>
											<p class="card-text">Community Outreach<br>Admin/Developer<br>Jan 2022<br><img src="images/discord_ico.png" width=25 height=20><a href="#" class="card-link"> Hax#3752</a></p>
										</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-6 ps-0">
								<div class="card mb-3 staff-card">
									<div class="row g-0">
										<div class="col-md-6">
										<img src="images/neckbeard.jpg"class="img-fluid rounded-start" alt="Neckbeard">
										</div>
										<div class="col-md-6">
										<div class="card-body staff-card-body">
											<h5 class="card-title">Neckbeard</h5>
											<p class="card-text">Public Relations<br>Admin/Developer<br>Jan 2022<br><img src="images/discord_ico.png" width=25 height=20><a href="#" class="card-link"> Strong#2362</a></p>
										</div>
										</div>
									</div>
								</div>
							</div>
						<div class="row">
							<div class="col-6 ps-0">
								<div class="card mb-3 staff-card">
									<div class="row g-0">
										<div class="col-md-6">
										<img src="images/carver.jpg"class="img-fluid rounded-start" alt="Box">
										</div>
										<div class="col-md-6">
										<div class="card-body staff-card-body">
											<h5 class="card-title">Box</h5>
											<p class="card-text">GM<br>Sep 2022<br><img src="images/discord_ico.png" width=25 height=20><a href="#" class="card-link"> Box#8889</a></p>
										</div>
										</div>
									</div>
								</div>
							</div>
							<div class="col-6 ps-0">
								<div class="card mb-3 staff-card">
									<div class="row g-0">
										<div class="col-md-6">
										<img src="images/carver.jpg"class="img-fluid rounded-start" alt="Aeltorian">
										</div>
										<div class="col-md-6">
										<div class="card-body staff-card-body">
											<h5 class="card-title">Aeltorian</h5>
											<p class="card-text">Developer<br>Jun 2023<br><img src="images/discord_ico.png" width=25 height=20><a href="#" class="card-link"> Aeltorian#0069</a></p>
										</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-md-4">
					<div class="card-body about-card" style="margin-left:1rem;">
						<div class="row px-3 py-0">

							<div class="container border border-success rounded p-3 about-card-body">
								<p>
								The best method of contacting us, and ensuring the appropriate GM receives your message, is by opening a <a href="https://discord.com/channels/696847769444548700/1027384629897986088" class="hyper-link">gm-support</a> ticket.
								</p>

								<p>
								While most of our GMs are open to receiving DMs from the community, please understand that they are volunteer staff and may not respond to you immediately.
								</p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="card mb-3 about-card">
		<h4 class="card-title">Open Staff Positions</h4>
			<div class="row g-0">
				<div class="col-md-4">
					<ul class="list-group">
						<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Project Manager</li>
						<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Developer</li>
						<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> GM</li>
						<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Quality Assurance</li>
					</ul>
				</div>
				<div class="col-md-8">
					<div class="card-body about-card" style="margin-left:1rem;">
						<div class="container border border-success rounded p-3 about-card-body">
							<p>
							If you are interested in joinining the CatsEye XI staff, open a <a href="https://discord.com/channels/696847769444548700/861074052999544862" class="hyper-link">#gm-support</a> ticket to begin the process.
							</p>
							<p>
							Please note that all staff positions are volunteer, and no compensation should be expected. In addition, all staff members are expected to uphold our code-of-conduct which includes, but is not limited to: protecting our modules branch code, maintaining a professional attitude, limiting information given to the community until the appropriate time, and being held to a higher standard of ethics.
							</p>
							<p>
							We do understand that this can be a huge commitment, so please consider carefully before applying.
							</p>
							<h5>What we look for in our staff members:</h5>
							<p>
							Typically, the staff that we accept have demonstrated a commitment to the community, a professional attitude, problem solving skills, the ability to learn quickly, and some technical aptitude either before or durring their GM application process.
							</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="card mb-3 about-card">
		<h4 class="card-title">Become a Contributor</h4>
			<div class="row g-0">
				<div class="col-md-8">
					<div class="container border border-success rounded p-3 about-card-body">
					<p>
					If you are an artist, graphic designer, musician, translator, or wish to contribute to CatsEye XI in some other way, start by opening a <a href="https://discord.com/channels/696847769444548700/861074052999544862" class="hyper-link">#gm-support</a> ticket!
					</p>
					<p>
					Contributors are recognized with an exclusive discord tag, and their name placed under the "special thanks" section of our website.
					</p>
					</div>
				</div>
				<div class="col-md-4">
					<div class="card-body about-card" style="margin-left:1rem;">
						<ul class="list-group">
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Graphic Designers</li>
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Artists</li>
							<li class="list-group-item"><img src="images/catseyexi.ico" width=30 height=30> Musicians</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
