<?php

function redirects($page) {
    header("Location:". PROTOCOL . BASE_PATH . BASE_FOLDER . "$page");
}

function getCraftbyID($id) {
  global $dbconn;
  
  $strSQL = "SELECT * from synth_recipes where ID=:id";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':id',$id);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0];
    }
  }
}

function getRecipesbyCraft($craft) {
  global $dbconn;
  
  $strSQL = "SELECT * from synth_recipes where ".$craft.">0 order by ".$craft." asc";
  $statement = $dbconn->prepare($strSQL);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function changeLook($charid,$face,$race,$size){
  global $dbconnwrite;
    
  $strSQL = "UPDATE char_look SET face=:face, race=:race, size=:size WHERE charid = :charid";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':face',$face);
  $statement->bindValue(':race',$race);
  $statement->bindValue(':size',$size);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'Error';
  }
  else {
    return '';
  }
}

function checkUsername($username) {
  global $dbconn;

  $strSQL = "SELECT * FROM accounts WHERE login=:login";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':login',strtolower($username));

  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return TRUE;
    }
    else {
      return FALSE;
    }
  }    
}

function checkCode($user,$code) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM accounts WHERE id=:user and verification_code=:code";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':user',$user);
  $statement->bindValue(':code',$code);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return TRUE;
    }
    else {
      return FALSE;
    }
  }    
}

function authenticate($username) {
  global $dbconn;
    
  $strSQL = "SELECT * FROM accounts WHERE (login = :username OR current_email = :username)";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':username',$username);
  if (!$statement->execute()) { 
    watchdog($statement->errorInfo(),'SQL'); 
  }
  else {
    $arrReturn = $statement->fetchAll(); 
  }
  if (!empty($arrReturn)) {
    $users['id'] = $arrReturn[0]['id'];
  }
  else {
    $users['id'] = 0;
  }
   
  $users['authed'] = TRUE;
  return $users;
}

function doLogin($username,$password) {
   global $dbconn;
   
  $strSQL = "SELECT *,(password = PASSWORD(:password)) as oldStylePassMatch FROM accounts WHERE (login = :username OR current_email = :username)";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':username',$_POST['username']);
  $statement->bindValue(':password',$_POST['password']);
  if (!$statement->execute()) { 
    watchdog($statement->errorInfo(),'SQL'); 
  }
  else {
    $arrReturn = $statement->fetchAll(); 
  }
  if (!empty($arrReturn)) {
    foreach ($arrReturn as $account) {
      if ($account['oldStylePassMatch']) {
        return TRUE;
      }
      else {
        if (password_verify($_POST['password'],$account['password'])) {
          return TRUE;
        }
      }
    }
    return FALSE;
  }
  else {
    return FALSE;
  }
}

function checkPassword($username,$password) {
   global $dbconn;
   
  $strSQL = "SELECT *,(password = PASSWORD(:password)) as oldStylePassMatch FROM accounts WHERE id=:username ";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':username',$username);
  $statement->bindValue(':password',$password);
  if (!$statement->execute()) { 
    watchdog($statement->errorInfo(),'SQL'); 
  }
  else {
    $arrReturn = $statement->fetchAll(); 
  }
  if (!empty($arrReturn)) {
    foreach ($arrReturn as $account) {
      if ($account['oldStylePassMatch']) {
        return TRUE;
      }
      else {
        if (password_verify($password,$account['password'])) {
          return TRUE;
        }
      }
    }
    return FALSE;
  }
  else {
    return FALSE;
  }
}

function checkEmail($username,$email) {
   global $dbconn;
   
  $strSQL = "SELECT * FROM accounts WHERE login=:username AND current_email = :email";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':username',$username);
  $statement->bindValue(':email',$email);
  if (!$statement->execute()) { 
    watchdog($statement->errorInfo(),'SQL'); 
  }
  else {
    $arrReturn = $statement->fetchAll(); 
  }
  if (!empty($arrReturn)) {
    return TRUE;
  }
  else {
    return FALSE;
  }
}

function isOnline($accid) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM accounts_sessions WHERE accid=:accid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':accid',$accid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return FALSE;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return FALSE;
    }
    else {
      return TRUE;
    }
  }
}

function isCharOnline($charid) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM accounts_sessions WHERE charid=:charid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return FALSE;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return FALSE;
    }
    else {
      return TRUE;
    }
  }
}


function getFame($fame) {
  
	$famelvl = 1;
	
	if ($fame >= 613) {
		$famelvl = 9;
	}
	elseif ($fame >= 550) {
		$famelvl = 8;
	}
	elseif ($fame >= 488) {
		$famelvl = 7;
	}
	elseif ($fame >= 425) {
		$famelvl = 6;
	}
	elseif ($fame >= 325) {
		$famelvl = 5;
	}
	elseif ($fame >= 225) {
		$famelvl = 4;
	}
	elseif ($fame >= 125) {
		$famelvl = 3;
	}
	elseif ($fame >= 50) {
		$famelvl = 2;
	}
		
	return $famelvl;
}

function getAccount($accid) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM accounts WHERE id=:accid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':accid',$accid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return NULL;
    }
    else {
      return $arrReturn[0]['login'];
    }
  }
}

function getAccountEmail($accid) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM accounts WHERE id=:accid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':accid',$accid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return NULL;
    }
    else {
      return $arrReturn[0]['current_email'];
    }
  }
}

function getAccounts($accid) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM accounts WHERE id=:accid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':accid',$accid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return NULL;
    }
    else {
      return $arrReturn[0];
    }
  }
}

function getCharacterID($accid) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM accounts_sessions WHERE accid=:accid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':accid',$accid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return NULL;
    }
    else {
      return $arrReturn[0]['charid'];
    }
  }
}

function getAH() {
  global $dbconn;
  
  $strSQL = "SELECT * from auction_house where sale=0 order by sell_date desc limit 100";
  $statement = $dbconn->prepare($strSQL);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getAHItemUnsold($itemid) {
  global $dbconn;
  
  $strSQL = "SELECT * from auction_house where itemid=:itemid and sale=0 order by price desc limit 100";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getAHItem($itemid,$stack) {
  global $dbconn;
  
  $strSQL = "SELECT * from auction_house where itemid=:itemid and sale>0 and stack=:stack order by sell_date desc limit 50";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  $statement->bindValue(':stack',$stack);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getAHPlayer($charid,$charname) {
  global $dbconn;
  
  $strSQL = "SELECT * from auction_house where (seller=:charid or buyer_name=:charname) and sale>0 order by sell_date desc limit 10";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':charname',$charname);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getAuctionCharid($charid) {
  global $dbconn;
  
  $strSQL = "SELECT * from auction_house where seller=:charid and sale=0 order by price desc";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getAuctionByID($id) {
  global $dbconn;
  
  $strSQL = "SELECT * from auction_house where id=:id and sale=0";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':id',$id);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getServerVariable($svar) {
  global $dbconn;
  
  $strSQL = "SELECT * from server_variables where name=:name";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':name',$svar);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchColumn(1);
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getServerVariables() {
  global $dbconn;
  
  $strSQL = "SELECT * from server_variables order by name desc";
  $statement = $dbconn->prepare($strSQL);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function secondsToTime($seconds){
    $diff = time() - $seconds;
    $calc_times = array();
    $timeleft   = array();
	if($diff > 86400){
	// Prepare array, depending on the output we want to get.
    $calc_times[] = array('Day',    'Days',    86400);
    $calc_times[] = array('Hour',   'Hours',   3600);

    foreach ($calc_times AS $timedata){
        list($time_sing, $time_plur, $offset) = $timedata;
        if ($diff >= $offset){
            $left = floor($diff / $offset);
            $diff -= ($left * $offset);
            $timeleft[] = "{$left} " . ($left == 1 ? $time_sing : $time_plur);
        }
    }
	
    return $timeleft ? (time() > $seconds ? null : '-') . implode(' ', $timeleft) : 0;
	}else{
		
    // Prepare array, depending on the output we want to get.
    $calc_times[] = array('Day',    'Days',    86400);
    $calc_times[] = array('Hour',   'Hours',   3600);
    $calc_times[] = array('Minute', 'Minutes', 60);

    foreach ($calc_times AS $timedata){
        list($time_sing, $time_plur, $offset) = $timedata;
        if ($diff >= $offset){
            $left = floor($diff / $offset);
            $diff -= ($left * $offset);
            $timeleft[] = "{$left} " . ($left == 1 ? $time_sing : $time_plur);
        }
    }
	
    return $timeleft ? (time() > $seconds ? null : '-') . implode(' ', $timeleft) : 0;
	}
}

function getOnlineList($online,$offset) {
  global $dbconn;
  $strSQL = "SELECT a.*, b.*, c.*, d.* from accounts_sessions a LEFT JOIN chars b ON a.charid = b.charid LEFT JOIN char_stats c ON b.charid=c.charid LEFT JOIN char_jobs d ON b.charid=d.charid where a.charid>:online ORDER BY b.charname LIMIT 50 OFFSET :offset";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':online',$online);
  $statement->bindValue(':offset', (int) $offset, PDO::PARAM_INT);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getLinkshell($linkshell) {
  global $dbconn;
  
  $strSQL = "SELECT * from linkshells where linkshellid=:linkshell";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':linkshell',$linkshell);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0];
    }
  }
}

function getLinkshellbyName($linkshell) {
  global $dbconn;
  
  $strSQL = "SELECT * from linkshells where name=:linkshell";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':linkshell',$linkshell);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0];
    }
  }
}

function hex2rgb($hex) {
	$hex = substr($hex, 1);
	$r=0;
	$g=0;
	$b=0;
   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,2,1).substr($hex,2,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,0,1).substr($hex,0,1));
   }
   $rgb = array($r, $g, $b);

   return $rgb;
}
	
function getEmail($accid) {
  global $dbconn;
  
  $strSQL = "SELECT current_email FROM accounts WHERE id=:accid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':accid',$accid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return NULL;
    }
    else {
      return $arrReturn[0]['email'];
    }
  }
}

function getLastACCID() {
  global $dbconn;
  
  $strSQL = "SELECT id FROM accounts order by id desc limit 1";
  $statement = $dbconn->prepare($strSQL);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return '';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0]['id'];
    }
  }
}

function getPasswordTime($code) {
  global $dbconn;
  
  $strSQL = "SELECT time FROM accounts_password_reset WHERE code=:code";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':code',$code);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
if (empty($arrReturn)) {
      return 'Invalid Code';
    }
    else {
      return $arrReturn[0]['time'];
    }
  }
}

function checkAccountEmail($email,$username) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM accounts WHERE current_email=:email and login=:username";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':email',$email);
  $statement->bindValue(':username',$username);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return TRUE;
    }
    else {
      return FALSE;
    }
  }    
}

function checkCharExists($charname) {
  global $dbconn;
  
  $strSQL = "SELECT charid FROM chars WHERE charname=:charname";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charname',$charname);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (!empty($arrReturn)) {
      return true;
    }
  }    

  return false;
}

function getLSChat($ls,$limit) {
  global $dbconn;
  
  $strSQL = "SELECT * from audit_chat where lsName = :ls order by lineID desc limit :limit";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':ls',$ls);
  $statement->bindValue(':limit',$limit, PDO::PARAM_INT);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getOnlineCount() {
  global $dbconn;
  
  $strSQL = "SELECT accid from accounts_sessions where accid>0";
  $statement = $dbconn->prepare($strSQL);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
if (empty($arrReturn)) {
      return '0';
    }
    else {
      return $statement->rowCount();
    }
  }
}

function getOnlineUCount() {
  global $dbconn;
  
  $strSQL = "SELECT DISTINCT client_addr from accounts_sessions";
  $statement = $dbconn->prepare($strSQL);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $statement->rowCount();
    }
  }
}

function getLastOnline($charid) {
  global $dbconn;
  
  $strSQL = "SELECT login_time from account_ip_record where charid=:charid order by login_time desc limit 1";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0];
    }
  }
}

function getAllChat($limit) {
  global $dbconn;
  
  $strSQL = "SELECT * from audit_chat where lineID >= 1 order by lineID desc limit :limit";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':limit',$limit, PDO::PARAM_INT);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getCommandLog($limit) {
  global $dbconn;
  
  $strSQL = "SELECT * from audit_gm where date_time >= 1 order by date_time desc limit :limit";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':limit',$limit, PDO::PARAM_INT);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getIPRecord($id) {
  global $dbconn;
  
  $strSQL = "SELECT * from account_ip_record where accid=:id";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':id',$id);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getIPRecords($ip) {
  global $dbconn;
  
  $strSQL = "SELECT * from account_ip_record where client_ip=:ip order by login_time desc";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':ip',$ip);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getGMList() {
  global $dbconn;
  
  $strSQL = "SELECT * from chars where gmlevel >= 1 order by gmlevel";
  $statement = $dbconn->prepare($strSQL);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}
function equip_to_item($id,$piece)
    {
  global $dbconn;
  
  $strSQL = "SELECT * from char_equip where charid=:id and equipslotid=:piece";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':id',$id);
  $statement->bindValue(':piece',$piece);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return '';
  }
  else{
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      
	$img=1;
	if($piece==0){
	$img=1;
	}
	elseif($piece==1){
	$img=2;
	}
	elseif($piece==2){
	$img=3;
	}
	elseif($piece==3){
	$img=4;
	}
	elseif($piece==4){
	$img=5;
	}	
	elseif($piece==5){
	$img=9;
	}
	elseif($piece==6){
	$img=10;
	}
	elseif($piece==7){
	$img=15;
	}
	elseif($piece==8){
	$img=16;
	}
	elseif($piece==9){
	$img=6;
	}
	elseif($piece==10){
	$img=14;
	}
	elseif($piece==11){
	$img=7;
	}
	elseif($piece==12){
	$img=8;
	}
	elseif($piece==13){
	$img=11;
	}
	elseif($piece==14){
	$img=12;
	}
	elseif($piece==15){
	$img=13;
	}
	
		return "<img src='http://static.ffxiah.com/images/eq$img.gif' height=32 width=32></img>";
    }
    else
	{

	$gear2=$arrReturn[0];
	
$slotid=$gear2['slotid'];
$containerid=$gear2['containerid'];

		if($slotid==0)
		{
		}
		else
		{
			$slotid=$gear2['slotid'];
			$containerid=$gear2['containerid'];

$slot=getSlotItem($id,$slotid,$containerid);
$items=getItem($slot['itemId']);
$item=$items[0];
$itemid=$slot['itemId'];
$itemname=str_replace('_',' ',$item['sortname']);
$itemname=ucwords($itemname);
$title=$itemname;
return "<div style='background: url(https://www.ffxiah.com/images/equip_box.gif);max-width: 32px;'><a href='?p=items&id=$itemid'><img src=http://static.ffxiah.com/images/icon/$itemid.png height='32' width='32' title='$title'></img></a></div>";

		}
	}
  }
}

function getSlotItem($charid,$slot,$container) {
  global $dbconn;
  
  $strSQL = "SELECT * from char_inventory where charid=:charid and slot=:slot and location=:container";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':slot',$slot);
  $statement->bindValue(':container',$container);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0];
    }
  }
}


function getCharacterName($charid) {
  global $dbconn;
  
  $strSQL = "SELECT charname FROM chars WHERE charid=:charid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return '';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0]['charname'];
    }
  }
}

function getCharacterByName($charname) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM chars WHERE charname=:charname";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charname',$charname);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return '';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0];
    }
  }
}

function getCharacterAccid($charid) {
  global $dbconn;
  
  $strSQL = "SELECT accid FROM chars WHERE charid=:charid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return '';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0];
    }
  }
}

function getCharacter($charid) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM chars LEFT JOIN char_stats ON chars.charid=char_stats.charid LEFT JOIN char_jobs ON chars.charid=char_jobs.charid LEFT JOIN char_look ON chars.charid=char_look.charid LEFT JOIN char_profile ON chars.charid=char_profile.charid LEFT JOIN accounts ON chars.accid=accounts.id WHERE chars.charid=:charid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getCharacterSkills($charid) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM char_skills WHERE charid=:charid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getCharacterList($accid) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM chars JOIN char_stats ON chars.charid=char_stats.charid JOIN char_jobs ON chars.charid=char_jobs.charid LEFT JOIN char_look ON chars.charid =char_look.charid WHERE accid=:accid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':accid',$accid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getCharacterGM($accid) {
  global $dbconn;
  
  $strSQL = "SELECT gmlevel FROM chars WHERE accid=:accid order by gmlevel desc";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':accid',$accid);
  
  if (!$statement->execute()) {
    return 'Error retrieving GM Level';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'Error retrieving GM Level';
    }
    else {
      return str_replace('_',' ',$arrReturn[0]['gmlevel']);
    }
  } 
}

function getCharacterVar($charid,$var) {
  global $dbconn;
  
  $strSQL = "SELECT value FROM char_vars WHERE charid=:charid and varname=:var";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':var',$var);
  
  if (!$statement->execute()) {
    return 'Error retrieving var';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'No Var';
    }
    else {
      return $arrReturn[0]['value'];
    }
  } 
}

function getCampaignList($var) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM char_vars WHERE varname=:var order by value";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':var',$var);
  
  if (!$statement->execute()) {
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  } 
}

function getCharacterRank($charid) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM char_profile WHERE charid=:charid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    return 'Error retrieving rank';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'No rank';
    }
    else {
      return $arrReturn[0];
    }
  } 
}

function getCharacterExp($charid) {
  global $dbconn;
  
  $strSQL = "SELECT * FROM char_exp WHERE charid=:charid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    return 'Error retrieving exp';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'No exp';
    }
    else {
      return $arrReturn[0];
    }
  } 
}

function getCharacterItem($charid,$itemid) {
  global $dbconn;

  $strSQL = "SELECT quantity FROM char_inventory WHERE charid=:charid and itemId=:itemid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    return 'Error retrieving item';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'No item';
    }
    else {
      return $arrReturn[0];
    }
  }
}

function getCharacterMaxRank($charid) {
  global $dbconn;
  
  $strSQL = "SELECT GREATEST(rank_sandoria, rank_bastok, rank_windurst) as maxrank from char_profile where charid=:charid;";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    return 'Error retrieving Rank';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'No Rank';
    }
    else {
      return $arrReturn[0]['maxrank'];
    }
  } 
}

function getCharacterMaxLevel($charid) {
  global $dbconn;
  
  $strSQL = "SELECT
GREATEST(war, mnk, whm, blm, rdm, thf, 
            pld, drk, bst, brd, rng, sam,
            nin, drg, smn, blu, cor, pup,
            dnc, sch, geo, run) as maxlevel
FROM char_jobs
WHERE charid = :charid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    return 'Error retrieving Level';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'No Level';
    }
    else {
      return $arrReturn[0]['maxlevel'];
    }
  } 
}

function getLinkshellbyChar($charid) {
  global $dbconn;
  
  $strSQL = "SELECT * from char_inventory where charid=:charid and (itemId=513 or itemId=514 or itemId=515)";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getPlayerVariable($pvar) {
  global $dbconn;
  
  $strSQL = "SELECT * from char_vars where charid=:id";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':id',$pvar);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getPlayerByVariable($pvar,$var) {
  global $dbconn;
  
  $strSQL = "SELECT value from char_vars where charid=:id and varname=:var";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':id',$pvar);
  $statement->bindValue(':var',$var);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0]['value'];
    }
  }
}

function setPlayerVariable($charid,$varname,$value) {
  global $dbconnwrite;
  
  $strSQL = "INSERT INTO char_vars (charid,varname,value) VALUES (:charid,:varname,:value)
  ON DUPLICATE KEY UPDATE value = :value;";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':varname',$varname);
  $statement->bindValue(':value',$value);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function deletePlayerVariable($charid,$varname) {
  global $dbconnwrite;
  
  $strSQL = "DELETE FROM char_vars where charid=:charid and varname=:varname";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':varname',$varname);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getSkill($charid,$skill) {
  global $dbconn;
  
  $strSQL = "SELECT * from char_skills where charid=:charid and skillid=:skill";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':skill',$skill);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return '0';
    } 
    else {
      return $arrReturn[0]['value']/10;
    }
  }
}

function getNamesList($name) {
  global $dbconn;
  
  $strSQL = "SELECT * from chars where charname like :name";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':name', '%' . $name . '%');
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getAccountsList($name) {
  global $dbconn;
  
  $strSQL = "SELECT * from accounts where login like :name";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':name', '%' . $name . '%');
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getBazaarItem($itemid) {
  global $dbconn;
  
  $strSQL = "SELECT a.*, b.* from char_inventory a LEFT JOIN chars b on a.charid=b.charid where itemId=:itemid and bazaar>0 order by bazaar desc";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getBazaarList($name) {
  global $dbconn;
  
  $strSQL = "SELECT a.*, b.* from item_basic a LEFT JOIN char_inventory b on a.itemid=b.itemId where (sortname like :name and bazaar>0) order by bazaar";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':name', '%' . $name . '%');
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getAllBazaar() {
  global $dbconn;
  
  $strSQL = "SELECT a.*, b.* from item_basic a LEFT JOIN char_inventory b on a.itemid=b.itemId where (bazaar>0 and bazaar<99999999) order by bazaar desc";
  $statement = $dbconn->prepare($strSQL);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getCharsbyItem($itemid) {
  global $dbconn;
  
  $strSQL = "SELECT charid,quantity from char_inventory where itemId=:itemid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}


function getBazaarPlayer($charid) {
  global $dbconn;
  
  $strSQL = "SELECT * from char_inventory where charid=:charid and bazaar>0 order by bazaar desc";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getPlayerInventory($charid) {
  global $dbconn;
  
  $strSQL = "SELECT a.itemId,a.quantity,b.sortname from char_inventory a RIGHT JOIN item_basic b on a.itemId=b.itemid where a.charid=:charid order by a.itemId";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function Unstuck($charid,$accid) {
  //global $dbconnwrite;
  
  return getPanel("warning","Warning","Something didn't work");
/*
  $strSQL = "UPDATE chars SET pos_zone='243', pos_rot='66', pos_x='0', pos_y='3', pos_z='116' where (charid=:charid and accid=:accid and pos_zone<>'131')";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':accid',$accid);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Your character was moved.");
  }
*/
}

function UpdateCharVar($charid, $varname, $value) {
  global $dbconnwrite;  
  $strSQL = "UPDATE char_vars set value = :value where charid = :charid and varname = :varname";
  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':varname',$varname);
  $statement->bindValue(':value',$value);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'Error';
  }
  else {
    return '';
  }
}

function updateEmail($email,$accid){
  global $dbconnwrite;
    
  $strSQL = "UPDATE accounts SET current_email = :email WHERE id = :accid";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':email',$email);
  $statement->bindValue(':accid',$accid);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'Error';
  }
  else {
    return '';
  }
}

function validateAccount($accid){
  global $dbconnwrite;
    
  $strSQL = "UPDATE accounts SET validated='1'  WHERE id = :accid";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':accid',$accid);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'Error';
  }
  else {
    return '';
  }
}

function updatePass($pass,$accid){
  global $dbconnwrite;
    
  $strSQL = "UPDATE accounts set password=password(:pass) WHERE id = :accid";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':pass',$pass);
  $statement->bindValue(':accid',$accid);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something Went wrong.");
  }
  else {
    return getPanel("success","Success","Password Updated");
  }
}

function updatePassword($pass,$username){
  global $dbconnwrite;
    
  $strSQL = "UPDATE accounts set password=password(:pass) WHERE login = :username";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':pass',$pass);
  $statement->bindValue(':username',$username);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something Went wrong.");
  }
  else {
    return getPanel("success","Success","Password Updated");
  }
}

function updateName($name,$charid){
  global $dbconnwrite;
    
  $strSQL = "UPDATE chars set charname=:name WHERE charid = :charid";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':name',$name);
  $statement->bindValue(':charid',$charid);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something Went wrong.");
  }
  else {
    return getPanel("success","Success","Charname Updated");
  }
}

function insertDeliveryBox($seller,$sellername,$itemid,$stack,$sender){
  global $dbconnwrite;  
  $strSQL = "INSERT INTO delivery_box (charid, charname, box, itemid, quantity, senderid, sender) VALUES (:seller,:sellername,'1',:itemid,:stack,'0',:sender)";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':seller',$seller);
  $statement->bindValue(':sellername',$sellername);
  $statement->bindValue(':itemid',$itemid);
  $statement->bindValue(':stack',$stack);
  $statement->bindValue(':sender',$sender);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Item sent to Delivery Box.");
  }
}

function createAccount($lastid,$user,$pass,$email,$today,$type,$referral,$code){
  global $dbconnwrite;  
  $strSQL = "Insert INTO accounts (id,login,password,current_email,registration_email,timecreate,content_ids,type,referral,verification_code,validated) VALUES (:lastid,:user,password(:pass),:email,:email,:today,:content_ids,:type,:referral,:code,'0')";
  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':lastid',$lastid);
  $statement->bindValue(':user',$user);
  $statement->bindValue(':pass',$pass);
  $statement->bindValue(':email',$email);
  $statement->bindValue(':today',$today);
  $statement->bindValue(':type',$type);
  $statement->bindValue(':referral',$referral);
  $statement->bindValue(':code',$code);

  if ($type == 1) {
    $statement->bindValue(':content_ids', 2);
  }
  elseif ($type == 2) {
    $statement->bindValue(':content_ids', 5);
  }
  else {
    $statement->bindValue(':content_ids', 1);
  }
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'Error';
  }
  else {
    return '';
  }
}

function AddCharVar($charid, $varname, $value) {
  global $dbconnwrite;  
  $strSQL = "Insert INTO char_vars (charid,varname,value) VALUES (:charid,:varname,:value)";
  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':varname',$varname);
  $statement->bindValue(':value',$value);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'Error';
  }
  else {
    return '';
  }
}

function applyException($accid,$date,$comment) {
  global $dbconnwrite;  
  $strSQL = "Insert INTO ip_exceptions (accid,exception,comment) VALUES (:accid,:date,:comment)";
  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':accid',$accid);
  $statement->bindValue(':date',$date);
  $statement->bindValue(':comment',$comment);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'Error';
  }
  else {
    return '';
  }
}

function changeException($accid,$date,$comment) {
  global $dbconnwrite;  
  $strSQL = "UPDATE ip_exceptions SET exception = :date, comment = :comment where accid = :accid";
  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':accid',$accid);
  $statement->bindValue(':date',$date);
  $statement->bindValue(':comment',$comment);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'Error';
  }
  else {
    return '';
  }
}

function deleteException($accid) {
  global $dbconnwrite;  
  $strSQL = "Delete from ip_exceptions where accid = :accid";
  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':accid',$accid);

 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'Error';
  }
  else {
    return '';
  }
}

function hasException($accid) {
  global $dbconn;  
  $strSQL = "Select * from ip_exceptions where accid=:accid";
  $statement = $dbconn->prepare($strSQL);  
  $statement->bindValue(':accid',$accid);

  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function countExceptions() {
  global $dbconn;  
  $strSQL = "Select COUNT(*) from ip_exceptions where exception='0000-00-00 00:00:00'";
  $statement = $dbconn->prepare($strSQL);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchColumn();
    
    if (empty($arrReturn)) {
      return '0';
    }
    else {
      return $arrReturn;
    }
  }
}

function countCampaigns($var) {
  global $dbconn;  
  $strSQL = "Select COUNT(*) from char_vars where varname=:var and value=1";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':var',$var);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchColumn();
    
    if (empty($arrReturn)) {
      return '0';
    }
    else {
      return $arrReturn;
    }
  }
}

function allException() {
  global $dbconn;  
  $strSQL = "Select * from ip_exceptions order by exception";
  $statement = $dbconn->prepare($strSQL);  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function KillSession($charid,$accid) {
  global $dbconnwrite;
  
  $strSQL = "Delete from accounts_sessions where charid=:charid and accid=:accid";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':accid',$accid);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Please wait at least one minute before trying to connect.");
  }
}

function getItemList($itemid) {
  global $dbconn;

  $strSQL = "SELECT * from item_basic where name like :itemid or sortname like :itemid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid', '%' . $itemid . '%');
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getItem($itemid) {
  global $dbconn;
  
  $strSQL = "SELECT * from item_basic where itemid=:itemid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getItems($itemid) {
  global $dbconn;
  
  $strSQL = "SELECT * from item_basic where itemid=:itemid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0];
    }
  }
}

function getItemName($itemid) {
  global $dbconn;
  
  $strSQL = "SELECT sortname from item_basic where itemid=:itemid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    return 'Error retrieving item name';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'Error retrieving item name';
    }
    else {
      return ucwords(str_replace('_',' ',$arrReturn[0]['sortname']));
    }
  } 
}

function getAHCountSingle($itemid) {
  global $dbconn;
  
  $strSQL = "select * from auction_house  where itemid=:itemid and stack = 0  and sell_date = 0"; 
  
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    return 'Error retrieving AH count';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'No';
    }
    else {
      return $statement->rowCount();
    }
  }
}


function getAHCountStack($itemid) {
  global $dbconn;
  
  $strSQL = "select * from auction_house  where itemid=:itemid and stack = 1  and sell_date = 0"; 
  
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    return 'Error retrieving AH count';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'No';
    }
    else {
      return $statement->rowCount();
    }
  }
}

function topSellers() {
  global $dbconn;
  
 $strSQL = "SELECT 
`sortname`,
a.itemid, 
COUNT(*) count_sold 
FROM auction_house a
JOIN item_basic b
ON 1=1
and a.itemid = b.itemid
WHERE CAST(FROM_UNIXTIME(sell_date) AS DATE) >= DATE_ADD(CURDATE(),  INTERVAL - 7 DAY)
GROUP BY `sortname`,
            itemid
order BY  count_sold desc LIMIT 20;
";

  $statement = $dbconn->prepare($strSQL);
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return NULL;
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return NULL;
    }
    else {
      return $arrReturn;
    }
  }
}


function getArmor($itemid) {
  global $dbconn;
  
  $strSQL = "SELECT * from item_equipment where itemId=:itemid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getWeapon($itemid) {
  global $dbconn;
  
  $strSQL = "SELECT * from item_weapon where itemId=:itemid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getUsable($itemid) {
  global $dbconn;
  
  $strSQL = "SELECT * from item_usable where itemid=:itemid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getFurniture($itemid) {
  global $dbconn;
  
  $strSQL = "SELECT * from item_furnishing where itemid=:itemid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getMods($itemid) {
  global $dbconn;
  
  $strSQL = "SELECT * from item_mods where itemid=:itemid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getLatents($itemid) {
  global $dbconn;
  
  $strSQL = "SELECT * from item_latents where itemid=:itemid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getItemDrops($itemid) {
  global $dbconn;

  $strSQL = "SELECT dropType, itemRate, mobid, polutils_name, zoneid from mob_droplist JOIN mob_groups on mob_droplist.dropId=mob_groups.dropid JOIN mob_spawn_points on mob_groups.groupid=mob_spawn_points.groupid and mob_groups.name=mob_spawn_points.mobname where mob_droplist.itemId=:itemid and mob_droplist.dropType>='0'";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getItemGuild($itemid) {
  global $dbconn;
  
  $strSQL = "SELECT * from guild_shops where itemid=:itemid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getCrafts($itemid) {
  global $dbconn;
  
  $strSQL = "SELECT * from synth_recipes where Ingredient1=:itemid or Ingredient2=:itemid or Ingredient3=:itemid or Ingredient4=:itemid or Ingredient5=:itemid or Ingredient6=:itemid or Ingredient7=:itemid or Ingredient8=:itemid or Result=:itemid or ResultHQ1=:itemid or ResultHQ2=:itemid or ResultHQ3=:itemid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':itemid',$itemid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getCrafters() {
  global $dbconn;
  
  $strSQL = "SELECT * FROM char_skills LEFT JOIN chars ON char_skills.charid=chars.charid LEFT JOIN accounts ON chars.accid = accounts.id WHERE chars.gmlevel < 1 AND VALUE > 500  and skillid>47 AND accounts.timelastmodify >= DATE_ADD(NOW(), INTERVAL -30 DAY) ORDER BY skillid, value desc";
  $statement = $dbconn->prepare($strSQL);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getMonsterList($monsterid) {
  global $dbconn;

  $strSQL = "SELECT * from mob_spawn_points where mobname like :mobname";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':mobname', '%' . $monsterid . '%');
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getMonster($monsterid,$zoneid) {
  global $dbconn;
  
  $strSQL = "SELECT a.*, b.*,c.* from mob_spawn_points a INNER JOIN mob_groups b ON a.mobname=b.name INNER JOIN mob_pools c ON b.poolid=c.poolid where a.mobid=:mob and b.zoneid=:zoneid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':mob',$monsterid);
  $statement->bindValue(':zoneid',$zoneid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getDrops($dropid) {
  global $dbconn;
  
  $strSQL = "SELECT a.*,b.* from mob_droplist a INNER JOIN item_basic b on a.itemId=b.itemid where dropId=:dropid and dropType>='0'";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':dropid',$dropid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getMobSkills($skilllist) {
  global $dbconn;
  
  $strSQL = "SELECT a.*,b.* from mob_skill_lists a INNER JOIN mob_skills b on a.mob_skill_id=b.mob_skill_id where skill_list_id=:skilllist";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':skilllist',$skilllist);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getMobSpells($spelllist) {
  global $dbconn;
  
  $strSQL = "SELECT a.*,b.* from mob_spell_lists a INNER JOIN spell_list b on a.spell_id=b.spellid where spell_list_id=:spelllist";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':spelllist',$spelllist);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getZoneName($zoneid) {
  global $dbconn;
  
  $strSQL = "SELECT name FROM zone_settings WHERE zoneid=:zoneid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':zoneid',$zoneid);
  
  if (!$statement->execute()) {
    return 'Error retrieving zone name';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return str_replace('_',' ',$arrReturn[0]['name']);
    }
  } 
}

function getMonstersByZone($zone) {
  global $dbconn;

  $strSQL = "SELECT * from mob_spawn_points JOIN mob_groups ON mob_spawn_points.groupid=mob_groups.groupid where mob_groups.zoneid=:zone";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':zone',$zone);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getCurrentZoneWeather($zone,$day) {
  global $dbconn;

  $strSQL = "SELECT * from weather where zoneid=:zone and weather_day<=:day order by weather_day desc limit 1";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':zone',$zone);
  $statement->bindValue(':day',$day);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0];
    }
  }
}

function getZoneWeather($zone,$day) {
  global $dbconn;

  $strSQL = "SELECT * from weather where zoneid=:zone and weather_day>:day limit 10";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':zone',$zone);
  $statement->bindValue(':day',$day);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getAllWeatherbyType($type,$type2) {
  global $dbconn;
  $strSQL = "SELECT * from weather where (common=:type or normal=:type or rare=:type or common=:type2 or normal=:type2 or rare=:type2)";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':type',$type);
  $statement->bindValue(':type2',$type2);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getOnlineListZone($zone) {
  global $dbconn;
  
  $strSQL = "SELECT a.*, b.*, c.*, d.* from accounts_sessions a LEFT JOIN chars b ON a.charid = b.charid LEFT JOIN char_stats c ON b.charid=c.charid LEFT JOIN char_jobs d ON b.charid=d.charid where b.pos_zone=:zone ORDER BY b.charname";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':zone',$zone);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getZoneList($zone) {
  global $dbconn;
  
  $strSQL = "SELECT * from zone_settings where NAME LIKE :zone";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':zone', '%'.$zone.'%');
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getZone($zoneid) {
  global $dbconn;
  
  $strSQL = "SELECT * from zone_settings where zoneid=:zoneid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':zoneid',$zoneid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getZoneline($zoneid) {
  global $dbconn;
  
  $strSQL = "SELECT * from zonelines where fromzone=:zoneid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':zoneid',$zoneid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn;
    }
  }
}

function getPanel($alert,$topic,$message){
	return "<div class='alert alert-$alert'>
        <div class='panel-heading'>
			<strong>$topic:</strong> <br> $message
		</div>
	</div>";
}

function getBreadCrumb($bread){
	return "<nav>
				<ol class='breadcrumb'>
					<li class='breadcrumb-item'>
						<a href='?p=home'>Home</a>
					</li>
					<li class='breadcrumb-item'>
						$bread
					</li>
				</ol>
			</nav>";			
}

function getBreadCrumbs($page,$bread,$crumb){
	return "<nav>
				<ol class='breadcrumb'>
					<li class='breadcrumb-item'>
						<a href='?p=home'>Home</a>
					</li>
					<li class='breadcrumb-item'>
						<a href='?p=$page'>$bread</a>
					</li>
					<li class='breadcrumb-item'>
						$crumb
					</li>
				</ol>
			</nav>";			
}


function getMaxCharid(){
  global $dbconn;
  
  $strSQL = "SELECT max(charid) FROM chars";
  $statement = $dbconn->prepare($strSQL);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0]['max(charid)'];
    }
  }
}

function createCharacter($charid,$accid,$charname,$poszone,$nation){
  global $dbconnwrite;  
  $strSQL = "INSERT INTO chars(charid,accid,charname,pos_zone,nation) VALUES (:charid,:accid,:charname,:poszone,:nation)";

  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':accid',$accid);
  $statement->bindValue(':charname',$charname);
  $statement->bindValue(':poszone',$poszone);
  $statement->bindValue(':nation',$nation);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Inserted Character.");
  }
}

function insertLook($charid,$face,$race,$size){
  global $dbconnwrite;  
  $strSQL = "INSERT INTO char_look(charid,face,race,size) VALUES (:charid,:face,:race,:size)";
  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':face',$face);
  $statement->bindValue(':race',$race);
  $statement->bindValue(':size',$size);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Inserted Look.");
  }
}

function insertStats($charid,$job){
  global $dbconnwrite;  
  $strSQL = "INSERT INTO char_stats(charid,mjob) VALUES (:charid,:job)";
  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':job',$job);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Inserted Stats");
  }
}

function insertExp($charid){
  global $dbconnwrite;  
  $strSQL = "INSERT INTO char_exp(charid) VALUES (:charid)";
  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Inserted EXP.");
  }
}

function insertJobs($charid){
  global $dbconnwrite;  
  $strSQL = "INSERT INTO char_jobs(charid) VALUES (:charid)";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Inserted Jobs.");
  }
}
function insertPoints($charid){
  global $dbconnwrite;  
  $strSQL = "INSERT INTO char_points(charid) VALUES (:charid)";
  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Inserted Points.");
  }
}

function insertUnlocks($charid){
  global $dbconnwrite;  
  $strSQL = "INSERT INTO char_unlocks(charid) VALUES (:charid)";
  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Inserted Unlocks");
  }
}

function insertProfile($charid){
  global $dbconnwrite;  
  $strSQL = "INSERT INTO char_profile(charid) VALUES (:charid)";
  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Inserted Profile");
  }
}

function insertStorage($charid){
  global $dbconnwrite;  
  $strSQL = "INSERT INTO char_storage(charid) VALUES (:charid)";
  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Inserted Storage.");
  }
}

function insertInventory($charid){
  global $dbconnwrite;  
  $strSQL = "INSERT INTO char_inventory(charid) VALUES (:charid)";
  $statement = $dbconnwrite->prepare($strSQL);  
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Inserted Inventory");
  }
}

function getCharacterCount($accid) {
  global $dbconn;  
  $strSQL = "Select COUNT(accid) from chars where accid=:accid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':accid',$accid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchColumn();
    
    if (empty($arrReturn)) {
      return '0';
    }
    else {
      return $arrReturn;
    }
  }
}


function getCharacterType($accid) {
  global $dbconn;  
  $strSQL = "Select type from accounts where id=:accid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':accid',$accid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchColumn();
    
    if (empty($arrReturn)) {
      return '0';
    }
    else {
      return $arrReturn;
    }
  }
}

function deleteCharacter($charid,$accid) {
  global $dbconnwrite;  
  $strSQL = "DELETE FROM chars where charid=:charid and accid=:accid and pos_zone<>'131'";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':accid',$accid);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work, additionally jailed characters can not be deleted");
  }
  else {
      return getPanel("success","Success","Your character was deleted");    
  }
}

function Jail($charid) {
  global $dbconnwrite;
  
  $strSQL = "UPDATE chars SET pos_zone='131', pos_x='-620', pos_y='12', pos_z='660' where charid=:charid";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Your character was moved.");
  }
}

function Pardon($charid) {
  global $dbconnwrite;
  
  $strSQL = "UPDATE chars SET pos_zone='243', pos_rot='66', pos_x='0', pos_y='3', pos_z='116' where charid=:charid";
  $statement = $dbconnwrite->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
 if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return getPanel("warning","Warning","Something didn't work");
  }
  else {
    return getPanel("success","Success","Your character was moved.");
  }
}

function random_str($length, $keyspace = '0123456789abcdefghijklmnopqrstuvwxyz')
{
//$a = random_str(32);
//$b = random_str(8, 'abcdefghijklmnopqrstuvwxyz');
    $pieces = [];
    $max = mb_strlen($keyspace, '8bit') - 1;
    for ($i = 0; $i < $length; ++$i) {
        $pieces []= $keyspace[random_int(0, $max)];
    }
    return implode('', $pieces);
}

function getCharacterPoints($charid) {
  global $dbconn;  
  $strSQL = "Select * from char_points where charid=:charid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0];
    }
  }
}

function setCharacterPoints($charid,$point,$value) {
  global $dbconnwrite;  
  $strSQL = "UPDATE char_points set :point=:value where charid=:charid";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':point',$point);
  $statement->bindValue(':value',$value);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return 'error';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return 'empty';
    }
    else {
      return $arrReturn[0];
    }
  }
}
