<?php

require_once("shared.php");

function createCharacter($charid,$accid,$charname,$poszone,$nation){
  global $dbconn;  
  $strSQL = "INSERT INTO chars(charid,accid,charname,pos_zone,nation) VALUES (:charid,:accid,:charname,:poszone,:nation)";

  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':accid',$accid);
  $statement->bindValue(':charname',$charname);
  $statement->bindValue(':poszone',$poszone);
  $statement->bindValue(':nation',$nation);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return '{ "insert_char": "failure" },';
  }
  else {
    return '{ "insert_char": "success" },';
  }
}

function insertLook($charid,$face,$race,$size){
  global $dbconn;  
  $strSQL = "INSERT INTO char_look(charid,face,race,size) VALUES (:charid,:face,:race,:size)";
  $statement = $dbconn->prepare($strSQL);  
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':face',$face);
  $statement->bindValue(':race',$race);
  $statement->bindValue(':size',$size);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return '{ "insert_look": "failure" },';
  }
  else {
    return '{ "insert_look": "success" },';
  }
}

function insertStats($charid,$job){
  global $dbconn;  
  $strSQL = "INSERT INTO char_stats(charid,mjob) VALUES (:charid,:job)";
  $statement = $dbconn->prepare($strSQL);  
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':job',$job);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return '{ "insert_stats": "failure" },';
  }
  else {
    return '{ "insert_stats": "success" },';
  }
}

function setPlayerVariable($charid,$varname,$value) {
  global $dbconn;
  
  $strSQL = "INSERT INTO char_vars (charid,varname,value) VALUES (:charid,:varname,:value)
  ON DUPLICATE KEY UPDATE value = :value;";
  $statement = $dbconn->prepare($strSQL);
  $statement->bindValue(':charid',$charid);
  $statement->bindValue(':varname',$varname);
  $statement->bindValue(':value',$value);
  
  if (!$statement->execute()) {
    watchdog($statement->errorInfo(),'SQL');
    return '{ "insert_var": "failure" },';
  }
  else {
    $arrReturn = $statement->fetchAll();
    
    if (empty($arrReturn)) {
      return '{ "insert_var": "success" },';
    }
    else {
      return '{ "insert_var": "update" },';
    }
  }
}

$race=$_GET['race'];
$face=$_GET['face'];
$size=$_GET['size'];
$job=$_GET['job'];
$name=$_GET['name'];
$nation=$_GET['nation'];
$acc_id=$_GET['acc_id'];
$char_id=$_GET['acc_id'];

?>